<?php
/* Copyright (C) 2017 Sergi Rodrigues <proyectos@imasdeweb.com>
 *
 * Licensed under the GNU GPL v3 or higher (See file gpl-3.0.html)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 *
 * phpcs:disable PEAR.NamingConventions.ValidFunctionName.ScopeNotCamelCaps
 * phpcs:disable PEAR.NamingConventions.ValidFunctionName.PublicUnderscore
 * phpcs:disable Generic.WhiteSpace.ScopeIndent.IncorrectExact
 */

/**
 *	\file       htdocs/stocktransfers/admin/config.php
 *      \defgroup   stocktransfers Module Stock transfers
 *      \brief      Settings page
 */

// == ACTIVATE the ERROR reporting
//ini_set('display_errors',1);ini_set('display_startup_errors',1);error_reporting(-1);

define('NOCSRFCHECK', 1);

include_once '../main_module.inc.php';

// == STOCKTRANSFERS_MODULE DOCUMENT_ROOT & URL_ROOT
if (!defined('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT')) {
	if (file_exists(DOL_DOCUMENT_ROOT.'/custom/stocktransfers/core/modules/modStocktransfers.class.php')) {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/custom/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/custom/stocktransfers');
	} else {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/stocktransfers');
	}
}

dol_include_once("core/lib/admin.lib.php");
dol_include_once("core/class/html.formadmin.class.php");

if (!$user->admin) accessforbidden();

$langs->load("admin");
$langs->load("other");
$langs->load("stocktransfers");
$langs->load("languages");

// == prepare languages translated for this module and get the translation for some keys

$ex_lang = explode('_', $langs->getDefaultLang()); // en_US
$defaultLang = $ex_lang[0];

include STOCKTRANSFERS_MODULE_DOCUMENT_ROOT.'/lib/stocktransfers.lib.php';
$languages = scandir(STOCKTRANSFERS_MODULE_DOCUMENT_ROOT.'/langs');
$multi_translations = f_multi_translation(array('STsettLab01def','stocktransfersPDF1','stocktransfersPDF8','stocktransfersPDF9','stocktransfersPDF10'), $languages);
//echo var_export($multi_translations,true);


/***************************************************
 *
 *	Actions / prepare data
 *
****************************************************/

// == request action by GET/POST

if (!empty($_POST['config'])) {
	//_evard($_POST,'$_POST');

	/* save incoming data */
		$db->begin();
		$error = 0;

	// = direct fields (like ['config']['STOCKTRANSFERS_MODULE_SETT_19'])
	foreach ($_POST['config'] as $K => $v) {
				$result = dolibarr_set_const($db, $K, $v, 'chaine', 0, '', $conf->entity);
				if (! $result > 0) $error ++;
	}

	/* message to user */
	if (! $error) {
				$db->commit();
				setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		$db->rollback();
		dol_print_error($db);
	}
}


/***************************************************
 *
 *	View
 *
****************************************************/

$help_url='';
llxHeader('', $langs->trans('stocktransfersMenuTitle2').' :: '.$langs->trans('STtabConfig'), $help_url);

// = first header row (section title & go back link)

	$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($langs->trans("stocktransfersSetup"), $linkback, 'tools');

// = alert about updates for this module

	$mod  = 'modStocktransfers';
	dol_include_once('/'.strtolower(substr($mod, 3)).'/core/modules/'.$mod.'.class.php');
	$objMod = new $mod($db);
	if (!isset($_SESSION[$mod.'_checkRes']) || $objMod->version != $_SESSION[$mod.'_currentVersion']) {
		$checkRes = $objMod->checkForUpdate();
		$_SESSION[$mod.'_checkRes'] = $checkRes; // to avoid ask remote server each visit to this page, asking only once per session
		$_SESSION[$mod.'_currentVersion'] = $objMod->version; // to force asking to remote server when user installed a new version in this same session
	}
	if ($_SESSION[$mod.'_checkRes'] > 0) {
		print "<div class='warning' style='margin:1rem 0;'><i class='fa fa-info-circle'></i> "
				.str_replace("{1}", "<a href='changelog.php'><u>ChangeLog</u></a>", $langs->trans($mod.'NewVersionAvailable'))
			."</div>";
	}

// = tabs of the section

	$h=0;

	$head[$h][0] = 'config.php';
	$head[$h][1] = $langs->trans("STtabConfig");
	$head[$h][2] = 'tabconfig';
	$h++;

	$head[$h][0] = 'bonus.php';
	$head[$h][1] = $langs->trans("STtabBonus");
	$head[$h][2] = 'tabbonus';
	$h++;

	$head[$h][0] = 'about.php';
	$head[$h][1] = $langs->trans("STtabAbout");
	$head[$h][2] = 'tababout';
	$h++;

	$head[$h][0] = 'changelog.php';
	$head[$h][1] = 'Changelog';
	$head[$h][2] = 'tabchangelog';
	$h++;

// = init current tab

	$html = new Form($db);

	dol_fiche_head($head, 'tabbonus', '', -1, '');

	print "\n<div style='padding:0 1.5em;'>";
?>

<form id="stocktransfersForm" name="stocktransfersForm" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="post">
	<input type="hidden" name="token" value="<?php echo newToken() ?>" />
	
	<p><?php echo $langs->trans("STtabBonusDesc") ?></p>

	<table class="noborder" style="width:auto;min-width:300px;">
		<tr class="liste_titre">
		<td><?php echo $langs->trans("STContext") ?></td>
		<td><?php echo $langs->trans("Name") ?></td>
			<td width="20%"><?php echo $langs->trans("Value") ?></td>
		</tr>
		
		<!-- ** CHECK STOCK AVAILABILITY WHEN CREATING A MANUFACTURING ORDER ** -->
		<tr>
			<td style="white-space:nowrap;"><b><?php echo $langs->trans("STsettTit08") ?></b></td>
			<td><?php echo $langs->trans("STsettLab22") ?></td>
			<td>
				<?php
					$value = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_22) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_22 : 'N' ;
					echo f_switch_control(array('name'=>'config[STOCKTRANSFERS_MODULE_SETT_22]','options'=>array('N','Y'),'value'=>$value));
				?>
			</td>
		</tr>

		<!-- ** SHOW LABEL & DESCRIPTION of THE SOURCE BOM OF A MANUFACTURING ORDER ** -->
		<tr>
			<td style="white-space:nowrap;"><b><?php echo $langs->trans("STsettTit09") ?></b></td>
			<td><?php echo $langs->trans("STsettLab23") ?></td>
			<td>
				<?php
					$value = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_23) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_23 : 'N' ;
					echo f_switch_control(array('name'=>'config[STOCKTRANSFERS_MODULE_SETT_23]','options'=>array('N','Y'),'value'=>$value));
				?>
			</td>
		</tr>

		<!-- ** SHOW LABEL & DESCRIPTION of THE PRODUCED PRODUCT OF A MANUFACTURING ORDER ** -->
		<tr>
			<td style="white-space:nowrap;"><b><?php echo $langs->trans("STsettTit09") ?></b></td>
			<td><?php echo $langs->trans("STsettLab24") ?></td>
			<td>
				<?php
					$value = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_24) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_24 : 'N' ;
					echo f_switch_control(array('name'=>'config[STOCKTRANSFERS_MODULE_SETT_24]','options'=>array('N','Y'),'value'=>$value));
				?>
			</td>
		</tr>

	</table>

	<!-- SUBMIT button -->

	<p style="text-align:left;margin:3rem 0;">
		<a href="#" onclick="$('#stocktransfersForm').submit();return false;" class="button"><?php echo dol_escape_htmltag($langs->trans("Save")) ?></a>
	</p>

	<!-- MODULE VERSION & USER GUIDE LINK -->
	<?php
		require_once STOCKTRANSFERS_MODULE_DOCUMENT_ROOT.'/core/modules/modStocktransfers.class.php';
		$module = new modStockTransfers($db);
		$user_lang = substr($langs->defaultlang, 0, 2);
	?>
	<div style="margin: 2rem 0;color: #ccc;display: inline-block;border-top: 1px #ccc solid;border-bottom: 1px #ccc solid;background-color: rgba(0,0,0,0.05);padding: 0.5rem;">
		<span class="help">Stock transfers <?php echo $module->version ?>
		   &nbsp; | &nbsp; <a href="https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=<?php echo $user_lang == 'es' ? '38':'39'?>" target="_blank"><?php echo $langs->trans('stocktransfersUserGuide') ?></a>
		</span>
	</div>

	<script>
		$(document).ready(function(){
			$('#stocktransfersForm').bind('submit',function(){
				var msg = js_validate_form('stocktransfersForm');
				if (msg!=""){
					alert(msg);
					return false;
				}
			});
		});

		function js_validate_form(form_id){

			/* prepare */
				var all_fine = true, fine = true, control, c_val, c_name, c_id;
				$(control).removeClass('alertedfield');
				$('#'+form_id+' tr').removeClass('alertedcontainer');

			/* check required fields */
				$('#'+form_id+' .fieldrequired').each(function(){
					/* = input fields = */
						control = $(this).closest('tr').find('input');
						c_val = $(control).val();
						c_name = $(control).attr('name');
						c_id = $(control).attr('id');
						if (c_name!=undefined){
							if (c_val=='') fine = false;
							if (!fine){
								all_fine = false;
								$(control).addClass('alertedfield');
								$(control).closest('tr').addClass('alertedcontainer');
							}
						}
					/* = select fields = */
						control = $(this).closest('tr').find('select');
						c_val = $(control).val();
						c_name = $(control).attr('name');
						c_id = $(control).attr('id');
						if (c_name!=undefined){
							if (c_val=='' || c_val=='-1') fine = false;
							if (!fine){
								all_fine = false;
								$(control).addClass('alertedfield');
								$(control).closest('tr').addClass('alertedcontainer');
							}
						}
				});

			/* submit form */
				if (!all_fine){
					return "You must populate some mandatory fields before submit changes.";
				}else{
					return "";
				}
		}

		$(document).ready(function(){
				$('form').on('click','.alertedfield',function(){
					$(this).removeClass('alertedfield');
				});
				$('form').on('click','.alertedcontainer',function(){
					$(this).removeClass('alertedcontainer');
				});
		});
	</script>

	<style>
		input.alertedfield, select.alertedfield, textarea.alertedfield{background-color:yellow!important;}
		.alertedcontainer td, .alertedcontainer td.fieldrequired{color:red!important;}
		.block{padding:0.5rem;background-color:rgba(100,100,100,0.05);border-radius:3px;border:1px rgba(100,100,100,0.2) solid;}
	</style>

<?php

dol_fiche_end();

print "</form>\n";
print "</div>\n";

clearstatcache();

dol_htmloutput_mesg($mesg);

llxFooter();

$db->close();
