<?php

/**
 * Class Actionsstocktransfers
*/
class Actionsstocktransfers
{


	/**
	 * @var DoliDB Database handler.
	 */
	public $db;

	/**
	 * @var string Error code (or message)
	 */
	public $error = '';

	/**
	 * @var array Errors
	 */
	public $errors = array();


	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();

	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;


	/**
	 * Constructor
	 *
	 *  @param		DoliDB		$db      Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;
	}


	/**
	 * context: mocard
	 * mission: check if the required products for a BoM has enough stock before create an new MO
	 *
	 * @param   array           $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    $object         The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          $action         Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             Return integer < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doActions($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs;
		$langs->load("stocktransfers@stocktransfers");

		//echo '<h3>$parameters</h3><pre>'.var_export($parameters, true).'</pre><h3>$_POST</h3><pre>'.var_export($_POST, true)."</pre><h3>object</h3><pre>";var_dump($object);echo "</pre>";die();

		if (empty($parameters['currentcontext'])) return 0;

		switch ($parameters['currentcontext']) {
			case 'mocard':
				if ($action!='add') return 0;

				// we only proceed if this action is ACCEPTED on the module settings
				if (empty($conf->global->STOCKTRANSFERS_MODULE_SETT_22) || $conf->global->STOCKTRANSFERS_MODULE_SETT_22=='N') return 0;

				dol_include_once('stocktransfers/lib/stocktransfers.lib.php');

				// Get BOM id and quantity to produce
				if (empty($_POST['fk_bom']) || empty($_POST['qty'])) return;
				$fk_bom = GETPOST('fk_bom', 'alpha');
				$qty    = GETPOST('qty', 'alpha');

				// Get BOM quantity produced
				$sql = "SELECT rowid,qty
							FROM ".MAIN_DB_PREFIX."bom_bom
							WHERE rowid=".$fk_bom;
				$elements = f_query($sql, 'rowid');
				if (!is_array($elements) || !isset($elements[$fk_bom])) return;
				$bom = $elements[$fk_bom];

				// Get BOM subproducts (not services) and stocks
				$sql = "SELECT ".MAIN_DB_PREFIX."bom_bomline.qty,".MAIN_DB_PREFIX."bom_bomline.fk_product,
							".MAIN_DB_PREFIX."bom_bomline.qty_frozen,
							".MAIN_DB_PREFIX."product.ref,".MAIN_DB_PREFIX."product.label ,
							".MAIN_DB_PREFIX."product.stock, ".MAIN_DB_PREFIX."product.fk_product_type  
							FROM ".MAIN_DB_PREFIX."bom_bomline JOIN ".MAIN_DB_PREFIX."product 
							ON ".MAIN_DB_PREFIX."bom_bomline.fk_product=".MAIN_DB_PREFIX."product.rowid 
							WHERE ".MAIN_DB_PREFIX."bom_bomline.fk_bom=".$fk_bom." 
							AND ".MAIN_DB_PREFIX."product.fk_product_type='0'";
				$bomlines = f_query($sql, 'fk_product');
				if (!is_array($bomlines) || count($bomlines)==0) return;

				// check stocks depending of quantity
				$without_stock = array();
				$qty_to_produce = floatval($qty);
				$qty_per_BOM    = floatval($bom['qty']);
				foreach ($bomlines as $prod) {
					if (empty($prod['qty_frozen'])) {
						$qty_needed = $qty_to_produce * (floatval($prod['qty']) / $qty_per_BOM);
					} else {
						$qty_needed = floatval($prod['qty']);
					}
					if ($qty_needed > floatval($prod['stock'])) {
						$without_stock[] = "Missing ".round($qty_needed - floatval($prod['stock']), 1)
											." units stock of ".$prod['label']." [".$prod['ref']."]. ";
					}
				}

				// if it's missing stock for any product
				if (count($without_stock)) {
					setEventMessage(implode('<br />', $without_stock),  'errors');
					header("Location: ".dol_buildpath('/mrp/mo_card.php?action=create&fk_bom='.((int) $fk_bom), 1).'&qty='.$qty);
					exit;
				}
				break;
		}

		return 0;
	}

	/**
	 * context: expeditioncard, productcard, productlotdocuments, mocard
	 * mission: to render a list of Documents of the linked order object (order sales for shipments, or BoM for Products)
	 *
	 * @param   array           $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    $object         The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          $action         Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             Return integer < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function formObjectOptions($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs;
		$langs->load("stocktransfers@stocktransfers");

		//$this->resprints = "<tr><td colspan='3'><pre>".var_export($object, true)."</pre></td></tr>"; //return 0;
		//print "<pre>".var_export($object, true)."</pre>"; //return 0;
		//error_log(' ooo ooo ooo ooo ooo  parameters: '.var_export($object->rowid, true));

		$currentcontext = !empty($parameters['currentcontext']) ? $parameters['currentcontext'] : '';

		switch ($currentcontext) {

			// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
			// render the name and description of the BoM and manufactured product in a MO card
			// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

			case 'mocard':

				// module settings
				$show_bom_details  = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_23) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_23 : 'N' ;
				$show_prod_details = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_24) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_24 : 'N' ;
				if ($show_bom_details=='N' && $show_prod_details=='N') return 0;

				// Get BOM record
				$bom_html = array();
				dol_include_once('stocktransfers/lib/stocktransfers.lib.php');
				$sql = "SELECT rowid,label,description FROM ".MAIN_DB_PREFIX."bom_bom WHERE rowid=".$object->fk_bom;
				$elements = f_query($sql, '');
				if (is_array($elements) && count($elements)!=0) {
					$bom = reset($elements);
					if (is_array($bom)) {
						if (!empty($bom['label']))       $bom_html[] = "<div onclick='$(this).next().toggle();' style='cursor:pointer;'>
																			<i class='fa fa-plus-square' style='opacity:0.6;'></i>&nbsp; <b>".$bom['label']."</b>
																		</div>";
						if (!empty($bom['description'])) $bom_html[] = "<div onclick='$(this).toggle();' style='cursor:pointer;display:none;'>".$bom['description']."</div>";
					}
				}

				// Get PRODUCED PRODUCT record
				$prod_html = array();
				$sql = "SELECT rowid,label,description FROM ".MAIN_DB_PREFIX."product WHERE rowid=".$object->fk_product;
				$elements = f_query($sql, '');
				if (is_array($elements) && count($elements)!=0) {
					$prod = reset($elements);
					if (is_array($prod)) {
						if (!empty($prod['label']))       $prod_html[] = "<div onclick='$(this).next().toggle();' style='cursor:pointer;'>
																			<i class='fa fa-plus-square' style='opacity:0.6;'></i>&nbsp; <b>".$prod['label']."</b>
																		</div>";
						if (!empty($prod['description'])) $prod_html[] = "<div onclick='$(this).toggle();' style='cursor:pointer;display:none;'>".$prod['description']."</div>";
					}
				}

				// render
				$html = "
				<script>
					$(document).ready(function(){
						let render_bom_details  = ".($show_bom_details=='Y'  && count($bom_html)>0  ? 'true':'false').";
						let render_prod_details = ".($show_prod_details=='Y' && count($prod_html)>0 ? 'true':'false').";
						if (render_bom_details) {
							$('td.fieldname_fk_bom:nth-child(2)').append($('#hidden_bom_description').html());
						}
						if (render_prod_details) {
							$('td.fieldname_fk_product:nth-child(2)').append($('#hidden_product_description').html());
						}
					});
				</script>
				<div id='hidden_bom_description' style='display:none;'>
					<div style='opacity:0.7;padding:0.6em 0;'>
						".implode('', $bom_html)."
					</div>
				</div>
				<div id='hidden_product_description' style='display:none;'>
					<div style='opacity:0.7;padding:0.6em 0;'>
						".implode('', $prod_html)."
					</div>
				</div>
				";

				// answer
				$this->resprints .= "<tr style='display:none;'><td colspan='3'>".$html."</td></tr>";

				break;
		}

		return 0;
	}

	/**
	 * context: expeditioncard, productcard, productlotdocuments, mocard
	 * mission: to render a list of Documents of the linked order object (order sales for shipments, or BoM for Products)
	 *
	 * @param   array           $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    $object         The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          $action         Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             Return integer < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function menuDropdownQuickaddItems($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs;
		
		$langs->load("stocktransfers@stocktransfers");

		$this->results = array(array(
								"url"        => "/custom/stocktransfers/transfer_edit.php?mainmenu=products&leftmenu=",
								"title"      => "stocktransfersNewTransfer@stocktransfers",
								"name"       => "stocktransfersBriefTitle@stocktransfers",
								"picto"      => "object_dolly",
								"activation" => $user->rights->stocktransfers->create,
								// "activation"=> true,
								// "activation" => $user->hasRight("user", "user", "write"), // vs hooking
								// "activation" => isModEnabled("product") && $user->hasRight("produit", "write"), // vs hooking
								"position"   => 60
						));

		return 0;
	}
}
