<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2016      Marcos García        <marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   produit     Module product variants
 *  \brief      Module to manage product combinations based on product attributes
 *  \file       htdocs/core/modules/modVariants.class.php
 *  \ingroup    produit
 *  \brief      Description and activation file for the module product variants
 */
include_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module Product variants
 */
class modVariants extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 610;
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'variants';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "products";
		// Module position in the family on 2 digits ('01', '10', '20', ...)
		$this->module_position = '50';
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = 'Allows creating products variant based on new attributes';
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = 'dolibarr';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto = 'product';

		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		$this->module_parts = array();

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/variants/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into variants/admin directory, to use to setup module.
		$this->config_page_url = array('admin.php@variants');

		// Dependencies
		$this->hidden = false; // A condition to hide module
		$this->depends = array('modProduct'); // List of module class names as string that must be enabled if this module is enabled
		$this->requiredby = array(); // List of module ids to disable if this one is disabled
		$this->conflictwith = array(); // List of module class names as string this module is in conflict with
		$this->phpmin = array(7, 0); // Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3, 0); // Minimum version of Dolibarr required by module
		$this->langfiles = array("products");

		// Constants
		$this->const = array();

		// Array to add new pages in new tabs
		$this->tabs = array(
		//	'product:+combinations:Combinaciones:products:1:/variants/combinations.php?id=__ID__'
		);

		// Dictionaries
		if (!isset($conf->variants->enabled)) {
			$conf->variants = new stdClass();
			$conf->variants->enabled = 0;
		}
		$this->dictionaries = array();

		// Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
		$this->boxes = array(); // List of boxes

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		$this->rights[$r][0] = $this->numero + 1; // Permission id (must not be already used)
		$this->rights[$r][1] = 'Read attributes of variants'; // Permission label
		$this->rights[$r][4] = 'read'; // In php code, permission will be checked by test if ($user->rights->eventorganization->level1)
		$r++;
		$this->rights[$r][0] = $this->numero + 2; // Permission id (must not be already used)
		$this->rights[$r][1] = 'Create/Update attributes of variants'; // Permission label
		$this->rights[$r][4] = 'write'; // In php code, permission will be checked by test if ($user->rights->eventorganization->level1)
		$r++;
		$this->rights[$r][0] = $this->numero + 3; // Permission id (must not be already used)
		$this->rights[$r][1] = 'Delete attributes of variants'; // Permission label
		$this->rights[$r][4] = 'delete'; // In php code, permission will be checked by test if ($user->rights->eventorganization->level1)
		$r++;
	}
}
