<?php
/* Copyright (C) 2017 Sergi Rodrigues <proyectos@imasdeweb.com>
 *
 * Licensed under the GNU GPL v3 or higher (See file gpl-3.0.html)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 *
 * phpcs:disable PEAR.NamingConventions.ValidFunctionName.ScopeNotCamelCaps
 * phpcs:disable PEAR.NamingConventions.ValidFunctionName.PublicUnderscore
 * phpcs:disable Generic.WhiteSpace.ScopeIndent.IncorrectExact
 */

/**
 *	\file       htdocs/stocktransfers/admin/changelog.php
 *      \defgroup   stocktransfers Module Stock transfers
 *      \brief      Changelog page
 */

 // == ACTIVATE the ERROR reporting
 //ini_set('display_errors',1);ini_set('display_startup_errors',1);error_reporting(-1);

define('NOCSRFCHECK', 1);

include_once '../main_module.inc.php';

dol_include_once("core/lib/admin.lib.php");

// == STOCKTRANSFERS_MODULE DOCUMENT_ROOT & URL_ROOT
if (!defined('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT')) {
	if (file_exists(DOL_DOCUMENT_ROOT.'/custom/stocktransfers/core/modules/modStocktransfers.class.php')) {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/custom/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/custom/stocktransfers');
	} else {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/stocktransfers');
	}
}
if (!$user->admin) accessforbidden();


$langs->load("admin");
$langs->load("other");
$langs->load("stocktransfers");


/******************
 *      View
 ******************/

$help_url='';
llxHeader('', $langs->trans('stocktransfersMenuTitle2').' :: CHANGELOG', '');

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print_fiche_titre($langs->trans("stocktransfersSetup"), $linkback, 'tools');

// = alert about updates for this module

	$mod  = 'modStocktransfers';
	dol_include_once('/'.strtolower(substr($mod, 3)).'/core/modules/'.$mod.'.class.php');
	$objMod = new $mod($db);
	if (!isset($_SESSION[$mod.'_checkRes']) || $objMod->version != $_SESSION[$mod.'_currentVersion']) {
		$checkRes = $objMod->checkForUpdate();
		$_SESSION[$mod.'_checkRes'] = $checkRes; // to avoid ask remote server each visit to this page, asking only once per session
		$_SESSION[$mod.'_currentVersion'] = $objMod->version; // to force asking to remote server when user installed a new version in this same session
	}
	if ($_SESSION[$mod.'_checkRes'] > 0) {
		print "<div class='warning' style='margin:1rem 0;'><i class='fa fa-info-circle'></i> "
				.str_replace("{1}", "<a href='changelog.php'><u>ChangeLog</u></a>", $langs->trans($mod.'NewVersionAvailable'))
			."</div>";
	}

// = tabs of the section

	$h=0;

	$head[$h][0] = 'config.php';
	$head[$h][1] = $langs->trans("STtabConfig");
	$head[$h][2] = 'tabconfig';
	$h++;

	$head[$h][0] = 'bonus.php';
	$head[$h][1] = $langs->trans("STtabBonus");
	$head[$h][2] = 'tabbonus';
	$h++;

	$head[$h][0] = 'about.php';
	$head[$h][1] = $langs->trans("STtabAbout");
	$head[$h][2] = 'tababout';
	$h++;

	$head[$h][0] = 'changelog.php';
	$head[$h][1] = 'Changelog';
	$head[$h][2] = 'tabchangelog';
	$h++;

	$search_query = 'imasdeweb';


// = init current tab

dol_fiche_head($head, 'tabchangelog', $langs->trans('stocktransfersMenuTitle2'), -1, 'stock');

	/* LOAD CHANGELOG (first remote version) */

	$content = file_get_contents('https://imasdeweb.com/UserFiles/dolibarr/'.strtolower(substr($mod, 3)).'/ChangeLog.md');

	/* LOAD CHANGELOG (local version, if failed the remote) */

	if ($content=='' || !preg_match('/MODULE CHANGELOG/i', $content)) {
		$content = file_get_contents(__DIR__.'/../ChangeLog.md');
	}

	/* POINT OUT INSTALLED VERSION */

	$currentVersion = trim(file_get_contents(__DIR__.'/../version.txt'));
	$lines = explode("\n", $content);
	foreach ($lines as $ii=>$line) {
		if (strpos($line, $currentVersion) === false) continue;
		$lines[$ii] = $line . ' __&larr; '.$langs->trans($mod.'CurrentInstalledVersion').'__';
	}
	$content = implode("\n", $lines);

	/* convert ChangeLog to Markdown */

	dol_include_once('/core/lib/parsemd.lib.php');
	$content = dolMd2Html($content);

	/* color in red the installed version */

	$content = str_replace(array("<strong>&larr;","<strong>&amp;larr;"), "<strong style='color:red;'>&larr;", $content);

	/* OUTPUT */

	print "<div style='padding:1em 2em;'>";
	print $content;
	print "</div>";

dol_fiche_end();

llxFooter();

$db->close();
