## Current version: 22.0.0 [2025-08-23]

Compatible with Dolibarr v. 5.X-21.X and PHP 8.2

## Description

The objective of this Dolibarr's module is to offer a more friendly interface than the Dolibarr native to transfer products from one warehouse to another of the company that owns Dolibarr. If you have installed the "Purchases" module (also from IMASDEWEB) then in case of lack of stock for the transfer, a button appears to create a new process to purchase the missing stock.

The module allows the download of a PDF file with the list of products to be transferred and space below for the triple signature of the one who makes the shipment, the carrier and the one who will receive the products in the destination warehouse, usual "delivery note" in this type of transportation.

Compatible with the multi-company module.

## Bonus 

As an extra, a series of small improvements have been added in some parts of Dolibarr that can be activated OPTIONALLY. For now:

- The creation of a Manufacturing Order (MO) can be prevented when there is insufficient physical stock of the products to be consumed.

- On a manufacturing order form, both the title and description of the associated Bill of Materials (BoM) and the produced product can be displayed.

## Interface language translations

Until now: English / French / Catalan / Spanish / German / Italian / Portuguese

## Slide presentation

[https://slides.com/caos30/dolibarr-stocktransfers-en](https://slides.com/caos30/dolibarr-stocktransfers-en)

## Initial author and history

Caos30 was the initial developer of this module, made for an specific customer on 2017. One year afterwards, caos30 decided in July 2018 to liberate the code of the module to make easy the contribution of other users, testers and developers. The final target is to be added to the core of the Dolibarr CMS, when the module be enough mature.

## Installation && update

- **Dolibarr Module Installation**: 

1. Go into menu Home - Setup - Modules - Deploy an external module, and submit the zip file
2. Go into menu Home - Setup - Modules, and activate the module. If you're updating, deactivate and activate again.
3. At a minimum, you must grant these permissions to the users who use it: Product stock -> Read warehouses and stocks.
4. You must also grant them at least these permissions from the Stocktransfers module: Read their transfers and/or others transfers.

- **Installation on automated hosting providers**: This module integrates seamlessly with Dolibarr's core, automatically detecting well-known providers like Bitnami. If you're using an unfamiliar provider, the module may require your assistance in locating the Dolibarr core file (main.inc.php) before functioning flawlessly. Please send to us your provider and custom location details to enhance the adaptability of this intelligent system.

- Complete information at: [https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39](https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39)

## License

LICENSE: GPL v3

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

## Links

- https://www.dolistore.com/en/modules/866-Stock-transfers.html
- https://slides.com/caos30/dolibarr-stocktransfers-en
- https://slides.com/caos30/dolibarr-stocktransfers
- User guide (english): https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39
- Manual de usuario (castellano): https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=38

## Team

As developers & translators:

 - DEV & translation to CA, EN, ES: Sergi Rodrigues (from 2017)
 - Italian translation: Marco Civra (2019)
 - German translation: Hans-Dieter Schondelmaier (2020)
 - French translation: Laurent Lebleu (2020)

## Versions Log

See file **ChangeLog.md** or see [ChangeLog.md](https://github.com/caos30/dolibarr_stocktransfers_module/blob/master/ChangeLog.md) file.

## ToDo list

 - increase user "virtual stock" for products "in transit" between 2 warehouses
 - add "entity" field at "transfers" table to make the module compatible with "multi-company" Dolibarr use
 - introduce user/group permissions
  
