## Version actuelle : 22.0.0 [2025-08-23]

Compatible avec Dolibarr v. 5.X-21.X et PHP 8.2

## Description

L'objectif de ce module Dolibarr est de proposer une interface plus conviviale que celle native de Dolibarr pour transférer des produits d'un entrepôt à un autre de l'entreprise propriétaire de Dolibarr. Si vous avez installé le module "Achats" (également d'IMASDEWEB), en cas de rupture de stock pour le transfert, un bouton apparaît pour créer un nouveau processus d'achat du stock manquant.

Le module permet le téléchargement d'un fichier PDF avec la liste des produits à transférer et un espace en dessous pour la triple signature de celui qui fait l'expédition, du transporteur et de celui qui recevra les produits dans l'entrepôt de destination, habituel "bordereau de livraison" dans ce type de transport.

Compatible avec le module multi-entreprises.

## Bonus

En plus, une série de petites améliorations ont été ajoutées dans certaines parties de Dolibarr qui peuvent être activées FACULTATIVEMENT. Pour l'instant :

- Il est possible d'empêcher la création d'un ordre de fabrication (OF) lorsqu'il n'y a pas suffisamment de stock physique des produits à consommer.

- Sur la fiche d'un ordre de fabrication, le titre et la description de la nomenclature associée ainsi que du produit fabriqué peuvent être affichés.

## Traductions de langue de l'interface

Jusqu'à présent : Français / Anglais / Catalan / Espagnol / Allemand / Italien / Portugais

## Présentation des diapositives

[https://slides.com/caos30/dolibarr-stocktransfers-en](https://slides.com/caos30/dolibarr-stocktransfers-en)

## Auteur initial et histoire

Caos30 a été le développeur initial de ce module, créé pour un client spécifique en 2017. Un an plus tard, en juillet 2018, caos30 a décidé de libérer le code du module pour faciliter la contribution d'autres utilisateurs, testeurs et développeurs. L'objectif final est d'être ajouté au cœur du CMS Dolibarr, lorsque le module sera suffisamment mature.

## Installation et mise à jour

- **Installation du module Dolibarr** :

1. Allez dans le menu Accueil - Configuration - Modules - Installer un module externe, et téléversez le fichier zip
2. Allez dans le menu Accueil - Configuration - Modules, et activez le module. Si vous faites une mise à jour, désactivez-le et réactivez-le.
3. Vous devez au minimum accorder ces permissions aux utilisateurs qui l'utilisent : Stock des produits -> Lire les entrepôts et les stocks.
4. Vous devez également leur accorder au minimum ces permissions du module Stocktransfers : Lire leurs transferts et/ou ceux des autres.


- **Installation sur des hébergeurs automatisés** : Ce module s'intègre parfaitement avec le cœur de Dolibarr, détectant automatiquement des hébergeurs bien connus comme Bitnami. Si vous utilisez un hébergeur inconnu, le module peut nécessiter votre aide pour localiser le fichier principal de Dolibarr (main.inc.php) avant de fonctionner sans problème. Merci de nous envoyer les détails de votre hébergeur et l'emplacement personnalisé pour améliorer l'adaptabilité de ce système intelligent.

- Informations complètes à : [https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39](https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39)

## Licence

LICENCE : GPL v3

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier selon les termes de la Licence Publique Générale GNU telle que publiée par la Free Software Foundation ; soit la version 3 de la Licence, ou (à votre choix) n'importe quelle version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de QUALITÉ MARCHANDE ou D'ADÉQUATION À UN USAGE PARTICULIER. Voir la Licence Publique Générale GNU pour plus de détails.

Vous devriez avoir reçu une copie de la Licence Publique Générale GNU avec ce programme ; sinon, écrivez à la Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

## Liens

- https://www.dolistore.com/fr/modules/866-Stock-transfers.html
- https://slides.com/caos30/dolibarr-stocktransfers-en
- https://slides.com/caos30/dolibarr-stocktransfers
- User guide (english): https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=39
- Manual de usuario (castellano): https://imasdeweb.com/index.php?pag=m_blog&gad=detalle_entrada&entry=38

## Équipe

En tant que développeurs & traducteurs:

 - DEV & traduction en CA, EN, ES: Sergi Rodrigues (depuis 2017)
 - Traduction italienne: Marco Civra (2019)
 - Traduction allemande: Hans-Dieter Schondelmaier (2020)
 - Traduction française: Laurent Lebleu (2020)

## Journal des versions

Voir le fichier **ChangeLog.md** ou voir [ChangeLog.md](https://github.com/caos30/dolibarr_stocktransfers_module/blob/master/ChangeLog.md) fichier.

## Liste des tâches

 - augmenter le "stock virtuel" de l'utilisateur pour les produits "en transit" entre 2 entrepôts
 - ajouter un champ "entité" à la table "transfers" pour rendre le module compatible avec l'utilisation "multi-société" de Dolibarr
 - introduire des permissions utilisateur/groupe

