<?php
/* Copyright (C) 2017 Sergi Rodrigues <proyectos@imasdeweb.com>
 *
 * Licensed under the GNU GPL v3 or higher (See file gpl-3.0.html)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\file       htdocs/stocktransfers/transfer_edit.php
 *      \defgroup   stocktransfers Module Stock transfers
 *      \brief      Edition of a transfer
 *      \version    v 1.0 2017/11/20
 */

include_once 'main_module.inc.php';

// == STOCKTRANSFERS_MODULE DOCUMENT_ROOT & URL_ROOT
if (!defined('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT')) {
	if (file_exists(DOL_DOCUMENT_ROOT.'/custom/stocktransfers/core/modules/modStocktransfers.class.php')) {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/custom/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/custom/stocktransfers');
	} else {
		define('STOCKTRANSFERS_MODULE_DOCUMENT_ROOT', DOL_DOCUMENT_ROOT.'/stocktransfers');
		define('STOCKTRANSFERS_MODULE_URL_ROOT', DOL_URL_ROOT.'/stocktransfers');
	}
}

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/stock/class/entrepot.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.commande.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/html.formproduct.class.php';
require_once STOCKTRANSFERS_MODULE_DOCUMENT_ROOT.'/lib/stocktransfers_transfer.class.php';

if (isModEnabled('projet')){
	require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formprojet.class.php';
}

$langs->load("products");
$langs->load("stocks");
$langs->load("orders");
$langs->load("productbatch");
$langs->load("projects");
$langs->load("stocktransfers");

include_once "./lib/stocktransfers.lib.php";
include_once DOL_DOCUMENT_ROOT."/core/class/html.formfile.class.php";

$user->getrights('stocktransfers');
$langs->load("stocktransfers@stocktransfers");

// == Get parameters
	$action = GETPOST('action', 'alpha');
	$transfer_id = GETPOST('rowid', 'int');
	if (empty($transfer_id)) $transfer_id = 0;

	$id_product = GETPOST('productid', 'int');
	$batch = GETPOST('batch', 'alpha');
	$qty = GETPOST('qty', 'int');

// == init hookmanager
	$hookmanager->initHooks(array('stocktransferscard'));

// == data object
	global $transfer;
	$transfer = new StockTransfer($db);
	if ($transfer_id > 0) {
		$ret = $transfer->fetch($transfer_id);
	}

// == Security check
	if ($transfer_id==0){
		if (empty($user->rights->stocktransfers->create)) accessforbidden();
	}else{
		if ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->read_others)) accessforbidden();
		if ($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->read_his)) accessforbidden();
	}

// == other data
	$now = dol_now();
	$listofdata=array();
	if (! empty($_SESSION['massstockmove'])) $listofdata=json_decode($_SESSION['massstockmove'], true);

// == SESSION MESSAGES (this is from this module)
if (!empty($_SESSION['EventMessages']) && is_array($_SESSION['EventMessages']) && count($_SESSION['EventMessages'])>0) {
	foreach ($_SESSION['EventMessages'] as $arr) {
		setEventMessages($arr[0], $arr[1], $arr[2]);
	}
}
	$_SESSION['EventMessages'] = array();


/***************************************************
 *
 *	Actions
 *
****************************************************/

if ($action == 'delete_transfer') {

	// == permissions checks
		$his_transfer = empty($transfer->rowid) || $transfer->fk_user_author==$user->id ? true : false;
		if ($his_transfer  && empty($user->rights->stocktransfers->delete_his)) accessforbidden();
		if (!$his_transfer && empty($user->rights->stocktransfers->delete_others)) accessforbidden();

	// == deletion
		if (!$transfer->rowid || $transfer->status != '0') {
			setEventMessage($langs->trans("stocktransfersErrorMsg04"),  'errors');
		} else {
			$transfer->delete();
			setEventMessage($langs->trans("RecordDeleted"),  'errors');
		}

	// == redirect to list
		header("Location: transfer_list.php?mainmenu=products&leftmenu="); die();

} elseif ($action == 'save_card') {

	// == change of status ?
		$previous_status = $transfer->status; // 0 (draft), V (validated), 1 (sent), 2 (received)
		$new_status = !empty($_POST['status']) ? $_POST['status'] : '0';
		$is_status_change = !empty($transfer->rowid) && $previous_status!=$new_status ? true : false;
		//echo _var($_POST); die();

	// == permission checks 
		$his_transfer = empty($transfer->rowid) || $transfer->fk_user_author==$user->id ? true : false;

		if ($is_status_change){
			if ($new_status=='V'){
				if ($his_transfer  && empty($user->rights->stocktransfers->validate_his)) accessforbidden();
				if (!$his_transfer && empty($user->rights->stocktransfers->validate_others)) accessforbidden();
			}else if ($new_status=='1'){
				if ($his_transfer  && empty($user->rights->stocktransfers->set_sent_his)) accessforbidden();
				if (!$his_transfer && empty($user->rights->stocktransfers->set_sent_others)) accessforbidden();
			}else if ($new_status=='2'){
				if ($his_transfer  && empty($user->rights->stocktransfers->set_received_his)) accessforbidden();
				if (!$his_transfer && empty($user->rights->stocktransfers->set_received_others)) accessforbidden();
			}else if ($new_status=='0'){
				if ($his_transfer  && empty($user->rights->stocktransfers->return_draft_his)) accessforbidden();
				if (!$his_transfer && empty($user->rights->stocktransfers->return_draft_others)) accessforbidden();
			}
		}

		if (empty($transfer->rowid) && empty($user->rights->stocktransfers->create)){
				accessforbidden();
		}

		if ((!empty($transfer->rowid) && !$his_transfer && empty($user->rights->stocktransfers->modify_meta_others))
			|| (!empty($transfer->rowid) && $his_transfer && empty($user->rights->stocktransfers->modify_meta_his))){
				accessforbidden();
		}

	// == prepare transfer card
		$transfer->fk_user_author = $user->id;
		if (!empty($_POST['label']))
			$transfer->label = $_POST['label'];
		elseif (empty($transfer->label))
			$transfer->label = $langs->trans("StockTransfer").' '.dol_print_date($now, '%Y-%m-%d %H:%M');

		if (isset($_POST['fk_project']))
		$transfer->fk_project = intval($_POST['fk_project']);

		if (isset($_POST['inventorycode']))
		$transfer->inventorycode = $_POST['inventorycode'];

		if (isset($_POST['fk_depot1']))
		$transfer->fk_depot1 = intval($_POST['fk_depot1']);

		if (isset($_POST['fk_depot2']))
		$transfer->fk_depot2 = intval($_POST['fk_depot2']);

		if (isset($_POST['date1'])) // == d/m/Y -> %Y%m%d%H%M%S
		$transfer->date1 = empty($_POST['date1']) || empty($_POST['date1year'])? '' : $_POST['date1year'].substr('0'.$_POST['date1month'], -2).substr('0'.$_POST['date1day'], -2);

		if (isset($_POST['date2'])) // == d/m/Y -> %Y%m%d%H%M%S
		$transfer->date2 = empty($_POST['date2']) || empty($_POST['date2year'])? '' : $_POST['date2year'].substr('0'.$_POST['date2month'], -2).substr('0'.$_POST['date2day'], -2);

		if (isset($_POST['shipper']))
		$transfer->shipper = $_POST['shipper'];

		if (isset($_POST['private_note']))
		$transfer->private_note = $_POST['private_note'];

		if (isset($_POST['pdf_note']))
		$transfer->pdf_note = $_POST['pdf_note'];

		if (isset($_POST['n_package']))
		$transfer->n_package = $_POST['n_package'];

		if (isset($_POST['status']))
			$transfer->status = $_POST['status'];

	// == run query on database

		$new = $transfer->rowid > 0 ? false : true ;
		if ($new)
			$result = $transfer->create(null);
		else 
			$result = $transfer->update();

	// == if there is a change of status,
	// __ then we add/remove records about stock movements

		// = the transfer is being stated as SENT
	if ($previous_status=='V' && $_POST['status']=='1') {
		$result = $transfer->create_stock_movements('1');

		// = the transfer is being stated as RECEIVED
	} elseif ($previous_status=='1' && $_POST['status']=='2') {
		$result = $transfer->create_stock_movements('2');

		// = the transfer is being stated AGAIN as DRAFT, from RECEIVED
	} elseif ($previous_status=='2' && $_POST['status']=='0') {
		$reverse = 1;
		$result = $transfer->create_stock_movements('2', $reverse);
		$result = $transfer->create_stock_movements('1', $reverse);

		// = the transfer is being stated AGAIN as DRAFT, from SENT
	} elseif ($previous_status=='1' && $_POST['status']=='0') {
		$reverse = 1;
		$result = $transfer->create_stock_movements('1', $reverse);
	}

	// == response to user

	if ($result < 0) {
		if ($previous_status!=$_POST['status']) {
			// rollback status change
			$transfer->status = $previous_status;
			$result = $transfer->update();
		}
		dol_print_error($db, $transfer->errors);
	} elseif ($new) {
		setEventMessage($langs->trans("RecordCreatedSuccessfully"),  'mesgs');
	} else {
		setEventMessage($langs->trans("RecordModifiedSuccessfully"), 'mesgs');
	}

	// == redirect to list
		header("Location: transfer_edit.php?mainmenu=products&leftmenu=&rowid=".$transfer->rowid); die();
} elseif ($action == 'add_line') {
	//echo _var($_POST,'$_POST');echo _var($transfer->products,'transfer products');

	if (empty($_POST['pid'])) {
		setEventMessage($langs->trans("ErrorGlobalVariableUpdater2", 'product'), 'errors');
	} elseif (empty($_POST['n'])) {
		setEventMessage($langs->trans("ErrorGlobalVariableUpdater2", 'n'), 'errors');
	} else {
		$old_line_ii = trim($_POST['line_ii']);
		$pid   = $_POST['pid'];
		$batch = !empty($_POST['batch']) ? trim($_POST['batch']) : '';
		$new_line_ii = $pid . ($batch!='' ? '_' . $transfer->sanitize_batch($batch) : '');

		// if there is a change on the product or/and the bacth of this line,
		// then we remove the old one, because the array index must be different
		if ($old_line_ii!='' && $old_line_ii!=$new_line_ii && $transfer->products[$old_line_ii]) {
			unset($transfer->products[$old_line_ii]);
		}

		// update/add product with incoming data
		$transfer->products[$new_line_ii] = array(
			'id'=>$pid,
			'n'=>floatval($_POST['n']),
			'b'=>$batch,
			'm'=>isset($_POST['m']) ? $_POST['m'] : '',
		);
		$transfer->n_products = count($transfer->products);

		//echo _var($transfer->products,'transfer products'); die();

		$result = $transfer->update();

		if ($result < 0)
			dol_print_error($db, $transfer->error);
		else setEventMessage($langs->trans("RecordModifiedSuccessfully"), 'mesgs');
	}

	// == redirect to list
		header("Location: transfer_edit.php?mainmenu=products&leftmenu=&rowid=".$transfer->rowid); die();
} elseif ($action == 'del_line') {
	if (empty($_POST['del_line_ii'])) {
		setEventMessage($langs->trans("ErrorGlobalVariableUpdater2", 'product'), 'errors');
	} else {
		$transfer->products[$_POST['del_line_ii']];
		$new_products = array();
		foreach ($transfer->products as $pid=>$p) {
			if ($pid != trim($_POST['del_line_ii'])) $new_products[$pid] = $p;
		}
		$transfer->products = $new_products;

		$result = $transfer->update();

		if ($result < 0) {
			dol_print_error($db, $transfer->error);
		} else {
			setEventMessage($langs->trans("RecordDeleted"), 'mesgs');
		}
	}

	// == redirect to list
		header("Location: transfer_edit.php?mainmenu=products&leftmenu=&rowid=".$transfer->rowid); die();
}

/***************************************************
 *
 *	View
 *
****************************************************/

print STRANS_render_view('edit', array('transfer'=>$transfer));
