<?php

/* Copyright (C) 2017 Sergi Rodrigues <proyectos@imasdeweb.com>
 *
 * Licensed under the GNU GPL v3 or higher (See file gpl-3.0.html)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\file       htdocs/stocktransfers/lib/views/edit.php
 *      \defgroup   Stocktransfers Stock Transfers
 *      \brief      Page to edit a stock transfer
 *      \version    v 1.0 2017/11/20
 */

/***************************************************
 *
 *	Prepare data
 *
****************************************************/

/* -- misc -- */

global $user, $conf, $langs;

$DOL_VERSION = intval(DOL_VERSION);
$socid = !empty($user->societe_id) > 0 ? $user->societe_id : 0;
$now=dol_now();

$form = new Form($db);
$formproduct = new FormProduct($db);
if (isModEnabled('projet')) {
	$formproject = new FormProjets($db);
} else {
	$formproject = null;
}
$productstatic = new Product($db);

$b_batch_enabled = isModEnabled('productbatch')
					&& (empty($conf->global->STOCKTRANSFERS_MODULE_SETT_08)
						|| $conf->global->STOCKTRANSFERS_MODULE_SETT_08 != 'N') ? true : false;

/* -- set order and limit for queries -- */
$sortfield = GETPOST('sortfield', 'alpha');
$sortorder = GETPOST('sortorder', 'alpha');
if (!$sortfield) {
	$sortfield = 'p.ref';
}
if (!$sortorder) {
	$sortorder = 'ASC';
}

/* -- load depots -- */

$depots = array();
$sql = "SELECT * FROM ".MAIN_DB_PREFIX."entrepot";
$elements = f_query($sql, '');
if (is_array($elements) && count($elements)>0) {
	foreach ($elements as $ele) {
		if (empty($ele['rowid'])) continue;
		$depots[$ele['rowid']] = $ele;
		$depots[$ele['rowid']]['tit1'] = !empty($ele['ref'])  ? $ele['ref']  : '#'.$ele['rowid'];
		$depots[$ele['rowid']]['tit2'] = !empty($ele['lieu']) ? $ele['lieu'] : (!empty($ele['label']) ? $ele['label'] : '');
		$depots[$ele['rowid']]['tit3'] = !empty($ele['town']) ? $ele['town'] : '';
	}
}

/* -- load current stock at all depots, of the products included in this transfer -- */

$stock = $transfer->getStock();
//_evar($stock,'$stock');

/* -- load the current stock for products with batches -- */

if ($b_batch_enabled) {
	$a_product_id = array(); foreach ($transfer->products as $p) {$a_product_id[]=$p['id'];}
	$batch_stock1 = $transfer->getProductsLots($a_product_id, $transfer->fk_depot1);
	$batch_stock2 = $transfer->getProductsLots($a_product_id, $transfer->fk_depot2);
	//_evar($batch_stock1,'$batch_stock MULTIPLE PRODUCTS');die();
}

/* -- need to purchase more stock -- */

$buy_stock = '';
$depot1_stock = array();
$depot2_stock = array();
if (count($transfer->products) > 0) {
	foreach ($transfer->products as $line_ii => $p) {
		// calculate stocks on departure and destination
		$pid = $p['id'];
		$depot1_stock[$pid] = !empty($stock[$transfer->fk_depot1][$pid]) ? floatval($stock[$transfer->fk_depot1][$pid]) : 0;
		$depot2_stock[$pid] = !empty($stock[$transfer->fk_depot2][$pid]) ? floatval($stock[$transfer->fk_depot2][$pid]) : 0;
		$missing_stock = floatval($p['n']) - $depot1_stock[$pid];
		if ($missing_stock > 0) {
			if ($buy_stock!='') $buy_stock .= '_';
			$buy_stock .= $pid.'-'.$missing_stock;
		}
	}
}

/***************************************************
 *
 *	View
 *
****************************************************/

/* -- browser top title -- */
$title = $langs->trans('stocktransfersBriefTitle');
llxHeader('', $title);

/* -- misc. -- */
$moreforfilter = true;
$var = true;
$param = '';
$filtertype=0;

/* -- include JS library to render HTML tooltips -- */
if (!empty($conf->use_javascript_ajax)) {
	print "\n".'<!-- Includes JS Footer of Dolibarr -->'."\n";
	$ext = 'layout='.$conf->browser->layout.'&version='.urlencode(DOL_VERSION);
	print '<script src="'.DOL_URL_ROOT.'/core/js/lib_foot.js.php?lang='.$langs->defaultlang.($ext ? '&'.$ext : '').'"></script>'."\n";
}

?>

<style><?php echo str_replace(array(" ","\n","\t"), '', file_get_contents(__DIR__.'/styles.css')) ?></style>

<!-- ========= header with section title ========= -->

<?php echo load_fiche_titre( ($transfer->rowid > 0 ? $langs->trans('stocktransfersTransfer') : $langs->trans('stocktransfersNewTransfer')),
					'<a href="transfer_list.php?mainmenu=products&leftmenu=" class="button">'
					.($DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-list"></i>&nbsp; ' : '')
					.$langs->trans('purchasesMenuTitle3').'</a>',
					'title_products.png') ?>


<div class='tabBar tabBarWithBottom'>

	<!-- ========= Form with the transfer details (dates, status, project, etc.) ========= -->

	<form action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" name="transfer_card_form" id="transfer_card_form">
		<input type="hidden" name="token" value="<?php echo newToken() ?>" />
		<input type="hidden" name="rowid" value="<?php echo !empty($transfer->rowid) ? $transfer->rowid : '' ?>" />
		<input type="hidden" name="action" value="save_card" />
		<input type="hidden" name="status" value="<?php echo $transfer->status ?>" />
		<input type="hidden" name="old_status" value="<?php echo $transfer->status ?>" />

		<?php
		$codemove=GETPOST('codemove', 'alpha');
		$labelmovement = GETPOST("label", 'alpha') ? GETPOST('label', 'alpha') : $langs->trans("StockTransfer").' '.dol_print_date($now, '%Y-%m-%d %H:%M');
		if ($DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME')) { // we can use fontwawesome icons
			$ic_warehouse = '<span class="fa fa-box-open"></span>';
		} else {
			$ic_warehouse = '<img src="'.DOL_URL_ROOT.'/theme/'.$conf->theme .'/img/object_company.png" border="0" />';
		}
		?>

		<div class="sk-container">
			<div class="sk-eight sk-columns">
				<div class="ficheaddleft">
					<table class="border" style="width:100%;">
						<?php if ($transfer->rowid > 0) { 
								$author = new User($db);
								$author->fetch($transfer->fk_user_author);
						?>
						<tr>
							<td class="titlefield fieldrequired"><?php echo $langs->trans('STID') ?></td>
							<td>#<?php echo $transfer->rowid ?></td>
						</tr>
						<tr>
							<td class="titlefield fieldrequired"><?php echo $langs->trans('Author') ?></td>
							<td><?php echo $author->getNomUrl(-1) ?></td>
						</tr>
						<?php } ?>
						<?php if (isModEnabled('projet')){ ?>
						<tr>
							<td class="titlefield"><?php echo $langs->trans('stocktransfersProject') ?></td>
							<td><?php echo $formproject->select_projects((empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) ? $socid :    -1), $transfer->fk_project, 'fk_project', 0, 0, 1, 1) ?></td>
						</tr>
						<?php } ?>
						<tr>
							<td class="titlefield fieldrequired"><?php echo $langs->trans('WarehouseSource') ?></td>
							<td><?php
							if ($transfer->status == '0') {
								// select control
								echo $formproduct->selectWarehouses($transfer->fk_depot1, 'fk_depot1', 'warehouseopen,warehouseinternal', 1, 0, 0, '', 0, 0, array(), 'minwidth200imp');
							} else {
								// hidden input
								echo "<input type='hidden' name='fk_depot1' id='fk_depot1' value='".$transfer->fk_depot1 ."' />";
							}

									// title & link to warehouse
							if (!empty($transfer->fk_depot1) && !is_null($transfer->fk_depot1)) {
								?>
									&nbsp; <a href="<?php echo DOL_URL_ROOT.'/product/stock/card.php?id='.$transfer->fk_depot1 ?>"><?php echo $ic_warehouse.' '.$depots[$transfer->fk_depot1]['tit1'] ?></a>
									 · <?php echo $depots[$transfer->fk_depot1]['tit2'] ?>
								<?php echo !empty($depots[$transfer->fk_depot1]['tit3']) ? ' · <em>'.$depots[$transfer->fk_depot1]['tit3'].'</em>' : '' ?>
									 
							<?php } ?>
							</td>
						</tr>
						<tr>
							<td class="titlefield fieldrequired"><?php echo $langs->trans('WarehouseTarget') ?></td>
							<td><?php
							if ($transfer->status == '0') {
								// select control
								echo $formproduct->selectWarehouses($transfer->fk_depot2, 'fk_depot2', 'warehouseopen,warehouseinternal', 1, 0, 0, '', 0, 0, array(), 'minwidth200imp');
							} else {
								// hidden input
								echo "<input type='hidden' name='fk_depot2' id='fk_depot2' value='".$transfer->fk_depot2 ."' />";
							}

							// title & link to warehouse & hidden input
							if (!empty($transfer->fk_depot2) && !is_null($transfer->fk_depot2)) {
								?>
										&nbsp; <a href="<?php echo DOL_URL_ROOT.'/product/stock/card.php?id='.$transfer->fk_depot2 ?>"><?php echo $ic_warehouse.' '.$depots[$transfer->fk_depot2]['tit1'] ?></a>
										 · <?php echo $depots[$transfer->fk_depot2]['tit2'] ?>
								 <?php echo !empty($depots[$transfer->fk_depot2]['tit3']) ? ' · <em>'.$depots[$transfer->fk_depot2]['tit3'].'</em>' : '' ?>
										 
							<?php } ?>
							</td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans('stocktransfersDate1') ?></td>
							<td>
								<?php echo $form->selectDate(!empty($transfer->date1) ? $db->jdate($transfer->date1) : '-1', 'date1', 0, 0, 0, "transfer_card_form", 1, 1) ?>
								<?php if ($transfer->status < '1') { ?>
								&nbsp; <button class="datenowlink" onclick="$('#date1').val('');return false;"><i class="fa fa-times-circle"></i></button>
								<?php } ?>
							</td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans('stocktransfersDate2') ?></td>
							<td>
								<?php if ($transfer->status > '0') { ?>
									<?php echo $form->selectDate(!empty($transfer->date2) ? $db->jdate($transfer->date2): '-1', 'date2', 0, 0, 1, "transfer_card_form", 1, 1) ?>
									<?php 	if ($transfer->status < '2') { ?>
										&nbsp; <button class="datenowlink" onclick="$('#date2').val('');return false;"><i class="fa fa-times-circle"></i></button>
									<?php 	} ?>
								<?php } ?>
							</td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans("stocktransfersShipper") ?></td>
							<td>
								<input type="text" name="shipper" style="width:200px;" maxlength="255" value="<?php echo dol_escape_htmltag($transfer->shipper) ?>">
							</td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans("stocktransfersNPackages") ?></td>
							<td>
								<input type="text" name="n_package" style="width:200px;" maxlength="20" value="<?php echo dol_escape_htmltag($transfer->n_package) ?>">
							</td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans("STinventorycode") ?></td>
							<td>
								<input type="text" name="inventorycode" style="width:300px;" maxlength="128" value="<?php echo dol_escape_htmltag($transfer->inventorycode) ?>">
							</td>
						</tr>
						<?php if ($transfer->rowid > 0) { ?>
						<tr>
							<td><?php echo $langs->trans("STLabelMovement") ?></td>
							<td>
								<input type="text" name="label"  style="width:300px;" maxlength="255" value="<?php echo dol_escape_htmltag($labelmovement) ?>">
							</td>
						</tr>
						<tr>
							<td class="titlefield fieldrequired"><?php echo $langs->trans("STStatus") ?></td>
							<td>
								<?php
								$label = $langs->trans('stocktransfersStatus'.$transfer->status).' '.$transfer->status;
								$status_icons = array('V'=>'fa-check','1'=>'fa-truck','2'=>'fa-check-circle');
								if ($DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME')) {
									$icon_class = isset($status_icons[$transfer->status]) ? $status_icons[$transfer->status] : 'fa-file-o';
									print '<i class="fa fa-lg '.$icon_class.'" style="opacity:0.4;color:inherit;" title="'.$label.'"></i>';
								} else {
									$picto = $transfer->status == '1' ? '3' : ( $transfer->status == '2' ? '4' : '0') ;
									print img_picto($label, 'statut'.$picto);
								}
								print ' '. $langs->trans('stocktransfersStatus'.$transfer->status);
								?>

								<!-- change status to VALIDATE -->
								<?php if ($buy_stock=='' && $transfer->rowid > 0 && $transfer->status == '0' && count($transfer->products) > 0) { ?>

									<?php if (($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->validate_his)) 
												|| ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->validate_others))){ ?>
										<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
											title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
											onclick="js_modal($(this).attr('title'), 'warning');return false;">
												<?php echo $langs->trans('stocktransfersSetStatusValidated') ?>
												<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-check"></i>':'' ?>
										</a>
									<?php }else{ ?>
										<a href="#" class="button" onclick="js_set_as_validated();return false;">
											<?php echo $langs->trans('stocktransfersSetStatusValidated') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-check"></i>':'' ?>
										</a>
									<?php } ?>

								<?php } ?>

								<!-- change status to sent button -->
								<?php if ($buy_stock=='' && $transfer->rowid > 0 && $transfer->status == 'V' && count($transfer->products) > 0) { ?>


									<?php if (($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->set_sent_his)) 
												|| ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->set_sent_others))){ ?>
										<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
											title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
											onclick="js_modal($(this).attr('title'), 'warning');return false;">
											<?php echo $langs->trans('stocktransfersSetStatusSent') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-truck"></i>':'' ?>
										</a>
									<?php }else{ ?>
										<a href="#" class="button" onclick="js_set_as_sent();return false;">
											<?php echo $langs->trans('stocktransfersSetStatusSent') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-truck"></i>':'' ?>
										</a>
									<?php } ?>


								<?php } ?>

								<!-- change status to received button -->
								<?php if ($transfer->rowid > 0 && $transfer->status == '1') { ?>

									<?php if (($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->set_received_his)) 
												|| ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->set_received_others))){ ?>
										<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
											title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
											onclick="js_modal($(this).attr('title'), 'warning');return false;">
											<?php echo $langs->trans('stocktransfersSetStatusReceived') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-check-circle"></i>':'' ?>
										</a>
									<?php }else{ ?>
										<a href="#" class="button" onclick="js_set_as_received();return false;">
											<?php echo $langs->trans('stocktransfersSetStatusReceived') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp;<i class="fa fa-check-circle"></i>':'' ?>
										</a>
									<?php } ?>

								<?php } ?>

								<!-- change status back to draft button -->
								<?php if ($transfer->status == 'V' || $transfer->status == '1' || $transfer->status == '2') { ?>

									<?php if (($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->return_draft_his)) 
												|| ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->return_draft_others))){ ?>
										<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
											title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
											onclick="js_modal($(this).attr('title'), 'warning');return false;">
											<?php echo $langs->trans('stocktransfersSetStatusDraft') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp; <i class="fa fa-rotate-left"></i>':'' ?>
										</a>
									<?php }else{ ?>
										<a href="#" class="button" onclick="js_set_as_draft();return false;">
											<?php echo $langs->trans('stocktransfersSetStatusDraft') ?>
											<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? ' &nbsp; <i class="fa fa-rotate-left"></i>':'' ?>
										</a>
									<?php } ?>

								<?php } ?>

							</td>
						</tr>
						<?php } ?>
					</table>
					<p style="padding:0;margin:0;">&nbsp;</p>
				</div>
			</div> <!-- end sk-column -->

			<div class="sk-four sk-columns">
				<div class="ficheaddleft">
					<table class="border" style="width:95%;">
						<tr>
							<td class="titlefield"><?php echo $langs->trans('STprivateNote') ?><br />
							<textarea name="private_note" class="note_textarea"><?php echo $transfer->private_note ?></textarea></td>
						</tr>
						<tr>
							<td class="titlefield"><?php echo $langs->trans('STpdfNote') ?><br />
							<textarea name="pdf_note" class="note_textarea"><?php echo $transfer->pdf_note ?></textarea></td>
						</tr>
					</table>
				</div>
			</div><!-- end sk-column -->

		</div> <!-- end sk-container -->

		<!-- =========== buttons ======== -->

		<br />
		<div class="center">

			<!-- save button -->
			<?php if (($transfer->rowid==0 && empty($user->rights->stocktransfers->create)) 
						|| ($transfer->rowid>0 && $transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->modify_meta_his)) 
						|| ($transfer->rowid>0 && $transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->modify_meta_others))){ ?>
			<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
				title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
				onclick="js_modal($(this).attr('title'), 'warning');return false;">
					<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-download"></i> ':'' ?>
					<?php echo $transfer->rowid > 0 ? dol_escape_htmltag($langs->trans('STSave')) : dol_escape_htmltag($langs->trans('CreateDraft')) ?>
				</a>
			<?php }else{ ?>
			<a href="#" class="button" onclick="js_validate_form('transfer_card_form');return false;">
				<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-download"></i> ':'' ?>
				<?php echo $transfer->rowid > 0 ? dol_escape_htmltag($langs->trans('STSave')) : dol_escape_htmltag($langs->trans('CreateDraft')) ?>
				</a>
			<?php } ?>

			<!-- delete button -->
			<?php if ($transfer->rowid > 0 && $transfer->status == '0') { ?>
				<?php if (($transfer->fk_user_author==$user->id && empty($user->rights->stocktransfers->delete_his)) 
							|| ($transfer->fk_user_author!=$user->id && empty($user->rights->stocktransfers->delete_others))){ ?>
				<a href="#" class="button" style="filter:grayscale(1);opacity:0.5;" 
					title="⛔ <?= str_replace(array("'",'"'),array("`",'“'),$langs->trans('stocktransfersNotAllowed')) ?>" 
					onclick="js_modal($(this).attr('title'), 'warning');return false;">
						<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-trash"></i> ':'' ?>
						<?php echo dol_escape_htmltag($langs->trans('STDelete')) ?>
					</a>
				<?php }else{ ?>
				<a href="#" class="button" onclick="js_delete_transfer();return false;">
					<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-trash" style="color:white;"></i> ':'' ?>
					<?php echo dol_escape_htmltag($langs->trans('STDelete')) ?>
				</a>
				<?php } ?>
			<?php } else { ?>
			<a style="opacity:0.5;filter:grayscale(1);" onclick="alert($(this).next().html());return false;"
				class="button classfortooltip button butActionDelete"
				title="<?php echo htmlentities($langs->trans('STDraftBeforeDelete')) ?>">
				<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? '<i class="fa fa-trash" style="color:white;"></i> ':'' ?>
				<?php echo dol_escape_htmltag($langs->trans('STDelete')) ?>
			</a>
			<span style="display:none;"><?php echo htmlentities($langs->trans('STDraftBeforeDelete')) ?></span>
			<?php } ?>

			<!-- hidden language selector for PDF -->
			<?php
				$languages = scandir(STOCKTRANSFERS_MODULE_DOCUMENT_ROOT.'/langs');
				$def_lang = !empty($conf->global->STOCKTRANSFERS_MODULE_SETT_16) ? $conf->global->STOCKTRANSFERS_MODULE_SETT_16 : 'auto';
				if ($def_lang=='auto') $def_lang = $langs->getDefaultLang();
				$PDFlang = !empty($transfer->lang) ? $transfer->lang : $def_lang;
				$langs->load("languages");
			?>
			<select id="sel_pdf_langcode" style="text-align:center;display:none;"
					onclick="$('#bt_download_pdf').attr('href','transfer_pdf.php?id=<?php echo $transfer->rowid ?>&l='+$(this).val());">
				<?php foreach ($languages as $langcode) {
						if ($langcode=='.' || $langcode=='..') continue;
					?>
				<option value="<?php echo $langcode ?>" <?php echo $langcode==$PDFlang ? "selected='selected'":"" ?>><?php echo $langs->trans('Language_'.$langcode) ?></option>
				<?php } ?>
			</select>

			<!-- pdf download button -->
			<?php if ($transfer->rowid > 0 && count($transfer->products) > 0) { ?>
			<a  id="bt_download_pdf"
				href="transfer_pdf.php?id=<?php echo $transfer->rowid ?>&l=<?php echo $PDFlang ?>" 
				class="button" target="_blank">
				<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME')
								? '<i class="fa fa-file-pdf"></i>&nbsp; '
								: '<img src="img/pdf.png" style="margin-bottom: -2px;" />' ?>
				<?php echo dol_escape_htmltag($langs->trans('stocktransfersPDFdownload')) ?>
			</a>
			
			<!-- pdf language button -->
			<a  href="#" onclick="$('#sel_pdf_langcode').toggle();return false;" style="display:inline-block;vertical-align:middle;">
				<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME')
								? '<i class="fa fa-2x fa-language"></i>'
								: '<img src="img/lang.png" style="margin-bottom: -2px;" />' ?>
			</a>
			
			<?php } ?>
			
			<!-- purchase proceed button -->
			
			<?php if ($buy_stock!='' && isModEnabled('purchases')){ 
						$fk_project = '&fk_project='.$transfer->fk_project ;
						if (is_dir(DOL_DOCUMENT_ROOT.'/custom/purchases'))
							$purchases_root = DOL_URL_ROOT.'/custom/purchases';
				else $purchases_root = DOL_URL_ROOT.'/purchases';
				?>
			<a  href="<?php echo $purchases_root ?>/purchase_edit.php?mainmenu=commercial&leftmenu=&products=<?php echo $buy_stock . $fk_project ?>" 
				class="classfortooltip button butActionDelete"
				title="<?php echo htmlentities($langs->trans('stocktransfersTooltip1')) ?>"><?php echo $langs->trans('stocktransfersGoShopping') ?></a>
			<?php } ?>

			<!-- =========== easter egg - to show the raw data of the element (mainly for dev debug) ======== -->

			<a href="#" onclick="return false;" ondblclick="$('#stocktransfers_easter_egg').toggle();return false;" style="text-decoration:none;">&nbsp; &nbsp;</a>
			<div id="stocktransfers_easter_egg" style="text-align: left;margin:2rem;display:none;" class="block">
				<?php
					$element_fields = array('rowid','ts_create','fk_user_author','label','inventorycode','fk_depot1',
											'fk_depot2','date1','date2','fk_project','shipper','n_package','status',
											's_products','n_products','n_items','private_note','pdf_note');
					$element = array();
					if (property_exists($transfer, 'rowid') && !empty($transfer->rowid)) {
						foreach ($element_fields as $f) {
							$element[$f] = !property_exists($transfer, $f) ? '' : $transfer->{$f};
						}
					}
					_evar($element);
					?>
			</div>

		</div>

	</form>

	<!-- ========= list of products transferred ========= -->

	<?php if ($transfer->rowid > 0) { ?>
	<br />
	<form action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" id="transfer_product_form">
		<input type="hidden" name="token" value="<?php echo newToken() ?>" />
		<input type="hidden" name="rowid" value="<?php echo !empty($transfer->rowid) ? $transfer->rowid : '' ?>" />
		<input type="hidden" name="action" value="add_line">
		<input type="hidden" name="del_line_ii" value="">
		<input type="hidden" name="line_ii" value="">

		<div class="div-table-responsive-no-max">
			<table class="liste">
				<tr class="liste_titre">
				<?php
					// Product Ref
					print getTitleFieldOfList($langs->trans('STProductRef'), 0, $_SERVER["PHP_SELF"], '', $param, '', 'class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);

					// Batch
					if ($b_batch_enabled) {
						print getTitleFieldOfList($langs->trans('STBatch'), 0, $_SERVER["PHP_SELF"], '', $param, '', 'class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);
					}

					// Line note
					print getTitleFieldOfList($langs->trans('STnote'), 0, $_SERVER["PHP_SELF"], '', $param, '', 'align="left" class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);
					
					// Qty
					$ic_truck = '<i class="fa fa-dolly"></i>';
					print getTitleFieldOfList($langs->trans('STQty').'<br />'.$ic_truck, 0, $_SERVER["PHP_SELF"], '', $param, '', 'align="center" class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);

					// Stock in source & target warehouses
					if ($transfer->status == '0') {
						$ic_house = '<i class="fa fa-home"></i>';
						print getTitleFieldOfList($langs->trans('STStock').'<br /><span style="font-size:0.8em;">'.$langs->trans('WarehouseSource').'</span>', 0, $_SERVER["PHP_SELF"], '', $param, '', 'align="center" class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);
						print getTitleFieldOfList($langs->trans('STStock').'<br /><span style="font-size:0.8em;">'.$langs->trans('WarehouseTarget').'</span>', 0, $_SERVER["PHP_SELF"], '', $param, '', 'align="center" class="tagtd maxwidthonsmartphone"', $sortfield, $sortorder);
					}

					// Hook fields
					global $hookmanager;
					$reshook = $hookmanager->executeHooks('printFieldListTitle'); // Note that $action and $object may have been modified by hook
					print $hookmanager->resPrint;

					// last column title (action buttons)
					print getTitleFieldOfList('', 0);
				?>
				</tr>

				<!-- ========= List of current added lines ========= -->

				<?php foreach ($transfer->products as $line_ii => $p) {
					$pid = $p['id'];
					$batch = $b_batch_enabled && !empty($p['b']) ? trim($p['b']) : '';
					if ($b_batch_enabled && $batch!='') {
						$stock1 = isset($batch_stock1[$pid][$batch]) && is_numeric($batch_stock1[$pid][$batch]['n']) && intval($batch_stock1[$pid][$batch]['n']) > 0 ? intval($batch_stock1[$pid][$batch]['n']) : 0;
						$stock2 = isset($batch_stock2[$pid][$batch]) && is_numeric($batch_stock2[$pid][$batch]['n']) && intval($batch_stock2[$pid][$batch]['n']) > 0 ? intval($batch_stock2[$pid][$batch]['n']) : 0;
					} else {
						$stock1 = is_numeric($depot1_stock[$pid]) ? intval($depot1_stock[$pid]) : 0;
						$stock2 = is_numeric($depot2_stock[$pid]) ? intval($depot2_stock[$pid]) : 0;
					}
					$needed_stock_this = $stock1 < floatval($p['n']);
					$productstatic->fetch($pid);
					?>

				<tr class='product' data-line_ii='<?php echo $line_ii ?>' data-pid='<?php echo $pid ?>'
					data-ref="<?php echo $productstatic->ref ?>"
					data-batch="<?php echo $b_batch_enabled ? trim($p['b']):'' ?>"
					data-n="<?php echo $p['n'] ?>"
					>
					<td>
						<?php echo $productstatic->getNomUrl(1).' - '.$productstatic->label ?>
						<div id="ST_pid_<?php echo $line_ii ?>_m" style="display:none;"><?php echo isset($p['m']) ? $p['m']:'' ?></div>
					</td>
					<?php if ($b_batch_enabled) {
							$a_dates = array();
						if (!empty($batch_stock1[$pid][$batch]['sellby'])) {
							$a_dates[] = $batch_stock1[$pid][$batch]['sellby'];
						}
						if (!empty($batch_stock1[$pid][$batch]['eatby'])) {
							$a_dates[] = $batch_stock1[$pid][$batch]['eatby'];
						}

							$dates = "";
							$dates = count($a_dates)==0 ? "":"<br /><i class='fa fa-calendar-o' style='opacity:0.5;margin-left:9px;'></i> <span style='opacity:0.7;font-size:0.9em;'>".implode(' | ', $a_dates)."</span>";
							$icon = !empty($p['b']) ? "<i class='fa fa-barcode fa-lg' style='opacity:0.7;'></i> ":"";
						?>
					<td style='white-space:nowrap;'>
						<?php echo $icon . $p['b'] . $dates ?>
					</td>
					<?php } ?>
					<td style='text-align:left;'>
						<em><?php echo $p['m'] ?></em>
					</td>
					<td style='text-align:center;'>
						<?php echo _qty($p['n']) ?>
					</td>
					<?php if ($transfer->status == '0') { ?>
					<td style='text-align:center;'>
						<?php echo $stock1 > 0 ? _qty($stock1) : '-' ?>
						<?php if ($needed_stock_this) { ?>
							<a href="<?php echo DOL_URL_ROOT ?>/product/stock/product.php?id=<?php echo $pid ?>&action=correction&id_entrepot=<?php echo $transfer->fk_depot1 ?>&token=<?php echo newToken() ?>"
								title="<?php echo str_replace('"', '', ($langs->trans('stocktransfersErrorMsg03')).' '.($langs->trans('stocktransfersAdjustStock'))) ?>"
								target="_blank" style="display:inline-block;margin:0px 4px;min-width:0;" class="button">
								<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? "<i class='fa fa-exclamation-triangle'></i>" : img_warning('') ?></a>
						<?php } ?>
					</td>
					<td style='text-align:center;'>
						<?php echo $stock2 > 0 ? _qty($stock2) : '-' ?>
					</td>
					<?php }
                    $hookmanager->executeHooks('printFieldListValue');
                    print $hookmanager->resPrint;
                    ?>
					<td>
						<?php if ($transfer->status == '0' ) { ?>
							<a href="#" onclick="js_edit_line('<?php echo $line_ii ?>');return false;" style="display:inline-block;float:left;margin:3px;min-width:0;" 
									class="button" title="<?php echo str_replace('"', '', $langs->trans("STedit"))?>">
								<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? "<i class='fa fa-pen fa-pencil'></i>" : img_edit($langs->trans("STedit")) ?></a>
							<a href="#" onclick="js_del_line('<?php echo $line_ii ?>');return false;" style="display:inline-block;float:left;margin:3px;min-width:0;" 
									class="button" title="<?php echo str_replace('"', '', $langs->trans("STRemove"))?>">
								<?php echo $DOL_VERSION >= 12 && !defined('DISABLE_FONT_AWSOME') ? "<i class='fa fa-trash' style='color:white;'></i>" : img_delete($langs->trans("STRemove")) ?></a>
						<?php } ?>
					</td>
				</tr>

				<?php } ?>

				<!-- ========= boxes to add a new line ========= -->

				<?php if ($transfer->status == '0' ) { ?>
				<tr id="new_line">

					<!-- ========= product ========= -->
					<td class="titlefield">
						<?php echo $form->select_produits(!empty($_POST['pid']) ? $_POST['pid'] : '', 'pid', $filtertype, getDolGlobalInt('PRODUIT_LIMIT_SIZE', 1000), 0, -1, 2, '', 0, array(), 0, '1', 0, 'maxwidth400', 1) ?>
					</td>

					<!-- ========= Batch/lot number ========= -->
					<?php if ($b_batch_enabled) { ?>
					<td id="stocktransfers_new_line_batch">
						<input type="text" name="batch" class="flat maxwidth50onsmartphone" style="width:100%;"
							placeholder="<?php echo str_replace('"', '', $langs->trans('STNotRequired')) ?>"
							value="<?php echo !empty($_POST['batch']) ? $_POST['batch'] : '' ?>">
					</td>
					<?php } ?>

					<!-- ========= Note (Message) ========= -->
					<td style='text-align:center;' class=''>
						<textarea size="3" class="flat" name="m" style="width:100%;"><?php echo !empty($_POST['m']) ? $_POST['m'] : '' ?></textarea>
					</td>

					<!-- ========= Quantity ========= -->
					<td style='text-align:center;' class=''>
						<input type="text" size="4" class="flat" name="n" value="<?php echo !empty($_POST['n']) ? $_POST['n'] : '' ?>">
					</td>

					<!-- ========= Automatic Stock ========= -->
					<td style='text-align:center;' class=''>
						<span id='new_line_stock1'></span>
					</td>
					<td style='text-align:center;' class=''>
						<span id='new_line_stock2'></span>
					</td>

                    <?php
                    $hookmanager->executeHooks('printFieldListAdd');
                    print $hookmanager->resPrint;
                    ?>

					<!-- ========= Button to add ========= -->
					<td style='text-align:left;'>
						<input id="ST_add" type="submit" class="button" value="<?php echo dol_escape_htmltag($langs->trans("STAdd")) ?>" />
						<input id="ST_save" type="submit" class="button" style="display:none;" value="<?php echo dol_escape_htmltag($langs->trans("STSave")) ?>" />
					</td>
				</tr>

				<?php } ?>

			</table>
			
		</div>

	</form>
	<br />

	<?php }  ?>

</div>

<script>

	var b_batch_enabled = <?php echo $b_batch_enabled ? 'true':'false' ?>;

	$(document).ready(function(){
		$('#transfer_product_form').bind('submit',function(){
			
			/* we don't check nothing if we're deleting a line  */
				if ($('#transfer_product_form input[name=action]').val()=='del_line') return;

			/* check data to add  */
				var msg = js_check_submit_add_line();
				if (msg!='') return false;

			/* alert if the product was already added before */
				var already_exists = false;
				var ref   = $('#new_line input[name=search_pid]').val();
				if (b_batch_enabled){
					var batch = $('#new_line input[name=batch]').val();
					if ($('#transfer_product_form tr[data-ref="'+ref+'"][data-batch="'+batch+'"]').length != 0){
						already_exists = true;
					}
				}else{
					if ($('#transfer_product_form tr[data-ref="'+ref+'"]').length != 0){
						already_exists = true;
					}
				}
				// alert if already exists
				if (already_exists){
					if (!confirm("<?php echo str_replace('"', '', html_entity_decode($langs->trans('STErrorMsg07'))) ?>")) {
						return false;
					}
				}
		});
		
		$('#pid').on('change',function(){
			js_update_stock_new_line('');
		});
	});

	var last_pid_stocked = '';
	
	function js_update_stock_new_line(line_ii){
		
		if (line_ii==''){
			line_ii = $('#transfer_product_form input[name=line_ii]').val();
		}
		
		var pid = $('#pid').val();
		if (pid=='' || pid==last_pid_stocked) return; // to avoid double queries by double click
		last_pid_stocked = pid;
		
		/* get from server the current stock for this product and departure warehouse */
		var url_json = 'json.php?action=get_stock'
						+'&pid='+pid
						+'&wid1=<?php echo $transfer->fk_depot1 ?>'
						+'&wid2=<?php echo $transfer->fk_depot2 ?>'
						+'&token=<?php echo currentToken() ?>';
		$.getJSON(
			url_json,
			function(data){
				//console.log(data);
				if (data.ok=='1'){
					var stock1 = data.stock['stock1'] ? data.stock['stock1'] : 0;
					var stock2 = data.stock['stock2'] ? data.stock['stock2'] : 0;
					$('#new_line_stock1').html('<b>'+stock1+'</b>');
					$('#new_line_stock2').html('<b>'+stock2+'</b>');
					
					// control to choose lot
					var status_batch = data.status_batch; // 0 -> no-batch-mode, 1 -> batch lots, 2 -> serial code (=1 batch/unit)
					if (status_batch=='2'){
						$('#new_line input[name=n]').attr('readonly','readonly').val('1');
					}else{
						$('#new_line input[name=n]').removeAttr('readonly');
					}
					
					var b_batch_enabled = <?php echo $b_batch_enabled ? 'true':'false' ?>;
					if (b_batch_enabled){
						if (line_ii==''){
							var line_batch = '';
						}else{
							var line_batch = $('#transfer_product_form table tr[data-line_ii='+line_ii+']').attr('data-batch');
						}
						var lot_control, selected, a_dateby, dateby; 
						var lots = data.lots; 
						if (status_batch!='0') {
							lot_control = '<select name="batch">';
							if (lots !== null && typeof lots === 'object' && Object.keys(lots).length > 0){
								for (let batch_key in lots) {
									if (lots.hasOwnProperty(batch_key)) {
										let arr = lots[batch_key];
										selected = (line_batch==batch_key) ? 'selected="selected"':'';
										if (arr['n']=='0' && selected=='') continue;
										a_dateby = [];
										if (arr['sellby']!='') a_dateby.push(arr['sellby']);
										if (arr['eatby']!='') a_dateby.push(arr['eatby']);
										dateby = a_dateby.join(' | ');
										lot_control += '<option value="'+batch_key+'" '+selected+'>'+batch_key+' ('+ (dateby==''?'-':dateby) +') '+arr['n']+'</option>';
									}
								}
							}
							lot_control += '</select>';
						}else{
							lot_control = '<input type="text" name="batch" class="flat maxwidth50onsmartphone" style="width:100%;" '
										+ ' value="" placeholder="(<?php echo str_replace('"', '', $langs->trans('STNotRequired')) ?>)" />';
						}
						$('#stocktransfers_new_line_batch').html(lot_control);
					}
				}
			}
		);
	}

	function js_check_submit_add_line(){
		
		
		/* check batch/lot serial number if this feature is enabled on Dolibarr */
		var b_batch_enabled = <?php echo $b_batch_enabled ? 'true':'false' ?>;
		var batch = '';
		if (b_batch_enabled===true){

			if ($('#new_line input[name=batch]').length >0)
				var batch = $('#new_line input[name=batch]').val();
			else if ($('#new_line select[name=batch]').length >0)
				var batch = $('#new_line select[name=batch]').val();
				
			batch = batch.trim();
		}
		
		/* read form values */
		if ($('#new_line select[name=pid]').length==1){
			var pid = parseInt($('#new_line select[name=pid]').val());
		}else if ($('#new_line input[name=pid]').length==1){
			var pid = parseInt($('#new_line input[name=pid]').val());
		}else if ($('#new_line select[name=search_pid]').length==1){
			var pid = parseInt($('#new_line select[name=search_pid]').val());
		}else if ($('#new_line input[name=search_pid]').length==1){
			var pid = parseInt($('#new_line input[name=search_pid]').val());
		}else{
			alert('Product select box not found, please contact developer.');
			return;
		}
		var qty = parseFloat($('#new_line input[name=n]').val());

		/* check product */
		var msg = '';
		if (isNaN(pid) || pid<1) {
			msg += "<?php echo html_entity_decode(str_replace('"', '', $langs->trans('STErrorMsg05'))) ?> ";
			$('#transfer_product_form span[role=combobox]').css('background-color','yellow');
			$('#transfer_product_form .select2').addClass('alertedcontainer');
		}

		/* check quantity */
		if (isNaN(qty) || qty<0) {
			msg += "<?php echo html_entity_decode(str_replace('"', '', $langs->trans('STErrorMsg06'))) ?> ";
			$('#transfer_product_form input[name=n]').addClass('alertedfield');
		}

		/* if wrong data, then show a warning message to user */
		if (msg!=''){
			alert(msg);
		}

		return msg;
	}

	function js_delete_transfer(){
		if (confirm("<?php echo str_replace('"', '', html_entity_decode($langs->trans('stocktransfersDelSure', '', 0))) ?>")){
			document.location = 'transfer_edit.php?mainmenu=products&action=delete_transfer&rowid=<?php echo $transfer->rowid ?>&token=<?php echo newToken() ?>';
		}
	}

	function js_edit_line(line_ii){
		
		$('#transfer_product_form input[name=line_ii]').val(line_ii);

		var tr  = $('#transfer_product_form table tr[data-line_ii='+line_ii+']');
		var pid = tr.attr('data-pid');
		if ($('#pid').hasClass('select2-hidden-accessible')){ /* Dolibarr +11.x */
			$('#pid').val(pid); // Select the option with a value of '1'
			$('#pid').trigger('change'); // Notify any JS components that the value changed
		}else{ /* Dolibarr versions until 10.x included */
			$('#new_line input[name=search_pid]').val(tr.attr('data-ref'));
			$('#new_line input[name=pid]').val(pid);
		}
		
		if (b_batch_enabled){
			if ($('#new_line input[name=batch]').length >0)
				$('#new_line input[name=batch]').val(tr.attr('data-batch'));
			else if ($('#new_line select[name=batch]').length >0)
				$('#new_line select[name=batch]').val(tr.attr('data-batch'));
		}
		
		$('#new_line input[name=n]').val(tr.attr('data-n'));
		$('#new_line textarea[name=m]').val($('#ST_pid_'+line_ii+'_m').html().replace('&amp;','&'));
		
		/* exchange save buttons */
		$('#ST_add').hide();
		$('#ST_save').hide().fadeIn();

		js_update_stock_new_line(line_ii);
	}

	function js_del_line(line_ii){
		if (!confirm("<?php echo str_replace('"', '', html_entity_decode($langs->trans('STconfirmDEL', '', 0))) ?>")) return;
		$('#transfer_product_form input[name=action]').val('del_line');
		$('#transfer_product_form input[name=del_line_ii]').val(line_ii);
		$('#transfer_product_form').submit();
	}

	function js_set_as_validated(){
		$('#transfer_card_form input[name=status]').val('V');
		js_validate_form('transfer_card_form');
	}

	function js_set_as_sent(){
		if ($('#transfer_card_form input[name=date1]').val()==''){
			$('#transfer_card_form input[name=date1]').addClass('alertedfield');
			alert("<?php echo html_entity_decode(str_replace('"', '\"', $langs->trans('stocktransfersErrorMsg01'))) ?>");
		}else{
			$('#transfer_card_form input[name=status]').val('1');
			js_validate_form('transfer_card_form');
		}
	}

	function js_set_as_received(){
		if ($('#transfer_card_form input[name=date2]').val()==''){
			$('#transfer_card_form input[name=date2]').addClass('alertedfield');
			alert("<?php echo html_entity_decode(str_replace('"', '\"', $langs->trans('stocktransfersErrorMsg02'))) ?>");
		}else{
			$('#transfer_card_form input[name=status]').val('2');
			js_validate_form('transfer_card_form');
		}
	}

	function js_set_as_draft(){
		$('#transfer_card_form input[name=status]').val('0');
		js_validate_form('transfer_card_form');
	}

	function js_validate_form(form_id){

		/* prepare */
			var all_fine = true, fine = true, control, c_val, c_name, c_id;
			$(control).removeClass('alertedfield');
			$('#'+form_id+' tr').removeClass('alertedcontainer');

		/* check required fields */
			$('#'+form_id+' .fieldrequired').each(function(){
				/* = input fields = */
					control = $(this).closest('tr').find('input');
					c_val = $(control).val();
					c_name = $(control).attr('name');
					c_id = $(control).attr('id');
					if (c_name!=undefined){
						if (c_val=='') fine = false;
						if (!fine){
							all_fine = false;
							$(control).addClass('alertedfield');
							$(control).closest('tr').addClass('alertedcontainer');
						}
					}
				/* = select fields = */
					control = $(this).closest('tr').find('select');
					c_val = $(control).val();
					c_name = $(control).attr('name');
					c_id = $(control).attr('id');
					if (c_name!=undefined){
						if (c_val=='' || c_val=='-1') fine = false;
						if (!fine){
							all_fine = false;
							$(control).addClass('alertedfield');
							$(control).closest('tr').addClass('alertedcontainer');
						}
					}
			});

		/* check warehouses (source and destiny) are not the same */
			if ($('#fk_depot1').val() == $('#fk_depot2').val()){
				$('#fk_depot1').closest('tr').addClass('alertedcontainer');
				$('#fk_depot2').closest('tr').addClass('alertedcontainer');
				all_fine = false;
			}

		/* submit form */
			if (all_fine){
				$('#'+form_id).submit();
			}

	}

	$(document).ready(function(){
		/* == put focus on the box to add a new product line == */
			if ($('#new_line td.titlefield').length){
				$('#new_line td.titlefield').find('label').focus();
			}

		/* set auto UN-ALERT */
			$('form').on('click','.select2.alertedcontainer span',function(){
				$('#transfer_product_form span[role=combobox]').css('background-color','');
				$('#transfer_product_form .select2').removeClass('alertedcontainer');
			});
			$('form').on('click','.alertedfield',function(){
				$(this).removeClass('alertedfield');
			});
			$('form').on('click','.alertedcontainer',function(){
				$(this).removeClass('alertedcontainer');
			});

	});
</script>
<div id="debug"></div>

<div id="doli_modal_dialog" style='display:none;'></div>
<script>
	function js_modal(msg, type=''){
		js_modal_close();
		let icon = type!='' && type=='error' ? "<p style='text-align:center;'><i class='fa fa-exclamation-circle fa-3x' style='opacity:0.5;'></i></p>":""
		let windowWidth = $(window).width() - 10;
		$("#doli_modal_dialog") .html(icon+"<p>"+msg+"</p>")
								.dialog({width:Math.min(windowWidth,500)+'px',modal: true});
	}
	function js_modal_close(){
		if ($('#doli_modal_dialog').is(':visible')){
			$("#doli_modal_dialog").dialog( "close" );
		}
	}
</script>

<style>
	input.alertedfield, select.alertedfield, textarea.alertedfield{background-color:yellow!important;}
	.alertedcontainer td, .alertedcontainer td.fieldrequired{color:red!important;}
	.block{padding:0.5rem;background-color:rgba(100,100,100,0.05);border-radius:3px;border:1px rgba(100,100,100,0.2) solid;}
</style>

<?php
	// End of page
	$db->close();
	llxFooter('');
