<?php
// Script simple para debug del logo
define('DOL_DATA_ROOT', '/var/www/html/pruebas/dolibarr2003/documents');

echo "=== DEBUG DEL LOGO ===\n";

// Verificar si existe el archivo de logo
$logoPath = DOL_DATA_ROOT . '/mycompany/logos/logo-casel.png';
echo "Ruta del logo: " . $logoPath . "\n";
echo "¿Existe el archivo? " . (is_file($logoPath) ? 'SÍ' : 'NO') . "\n";

if (is_file($logoPath)) {
    echo "Tamaño del archivo: " . filesize($logoPath) . " bytes\n";
    $imageInfo = getimagesize($logoPath);
    if ($imageInfo) {
        echo "Dimensiones: " . $imageInfo[0] . "x" . $imageInfo[1] . "\n";
    }
}

// Listar todos los archivos en el directorio de logos
echo "\n=== ARCHIVOS EN EL DIRECTORIO DE LOGOS ===\n";
$logosDir = DOL_DATA_ROOT . '/mycompany/logos/';
if (is_dir($logosDir)) {
    $files = scandir($logosDir);
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            echo "- " . $file . "\n";
        }
    }
} else {
    echo "El directorio no existe: " . $logosDir . "\n";
}

// Verificar permisos del archivo
if (is_file($logoPath)) {
    echo "\n=== PERMISOS DEL ARCHIVO ===\n";
    echo "Permisos: " . substr(sprintf('%o', fileperms($logoPath)), -4) . "\n";
    echo "Propietario: " . posix_getpwuid(fileowner($logoPath))['name'] . "\n";
    echo "Grupo: " . posix_getgrgid(filegroup($logoPath))['name'] . "\n";
}

echo "\n=== FIN DE DEBUG ===\n";
?> 