<?php
/* Copyright (C) 2023 TuNombre <tucorreo@ejemplo.com> - Licencia GPLv3+ */

include_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';

class modVentasPorCliente extends DolibarrModules
{
    public function __construct($db)
    {
        global $langs;

        parent::__construct($db); // ¡Obligatorio para Dolibarr 21+!

        // Configuración básica del módulo
        $this->numero = 104001; // ID único
        $this->rights_class = 'ventasporcliente';
        $this->family = "crm";
        $this->name = preg_replace('/^mod/i', '', get_class($this));
        $this->description = "Reporte detallado de ventas por cliente o terminal TakePOS";
        $this->editor_name = "TuNombre";
        $this->editor_url = "https://tusitio.com";
        $this->version = '1.0';
        $this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
        $this->picto = 'bill';

        // Dependencias (opcional)
        $this->module_parts = array(
            'hooks' => array(), // Hooks si son necesarios
            'triggers' => 0    // Desactivar triggers
        );

        // Configuración del menú TOP (barra superior)
        $this->menu = array(
            array(
                'fk_menu' => 0,                      // 0 para menú principal
                'type' => 'top',                     // Tipo TOP = barra superior
                'titre' => 'Ventas por Cliente',     // Texto visible
                'mainmenu' => 'ventasporcliente',    // ID único
                'url' => '/ventasporcliente/index.php',
                'langs' => 'ventasporcliente@ventasporcliente',
                'position' => 100,                   // Orden (100 = después de "Inicio")
                'enabled' => '$conf->ventasporcliente->enabled',
                'perms' => '$user->rights->societe->lire', // Permisos
                'target' => '',
                'user' => 0                          // 0 = todos los usuarios
            )
        );
    }

    // Función para inicializar el módulo (crear tablas, constantes, etc.)
    public function init($options = '')
    {
        $sql = array();
        
        // Crear constante para activar/desactivar módulo
        $this->const = array(
            array(
                'VENTASPORCLIENTE_ENABLED',
                'chaine',
                '1',
                'Módulo Ventas por Cliente activado',
                0,
                'current',
                1
            )
        );

        return $this->_init($sql, $options);
    }
}
