<?php
// For root directory
$res = @include('../../../main.inc.php');
// For "custom" directory
if(!$res) {
    $res = @include('../../../../main.inc.php');
}
require_once DOL_DOCUMENT_ROOT."/compta/facture/class/facture.class.php";
require_once DOL_DOCUMENT_ROOT."/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT."/core/class/discount.class.php";
dol_include_once('/pos/class/cash.class.php');
dol_include_once('/pos/class/place.class.php');
dol_include_once('/pos/backend/lib/pos.lib.php');

global $langs,$db,$mysoc,$conf;

$langs->load('main');
$langs->load('pos@pos');
$langs->load('rewards@rewards');
$langs->load('bills');
$id = GETPOST('id');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Print facture</title>
    <style type="text/css">
        body {
            font-size: 14px;
            position: relative;
            font-family: monospace,courier,arial,helvetica,system;
            margin: 35px;
        }

        .entete {
            width: 100%;
            /*position: relative;*/
        }

        .infos {
            position: relative;
            font-size: 14px;
            width: 100%;
            text-align: center;
        }

        .logo {
            width: 100%;
            text-align: center;
        }

        .adresse {
            /*float: left;*/
            font-size: 12px;
        }

        .tables {
            display: block;
            width: 100%;
        }

        .liste_articles {
            width: 100%;
            border-bottom: 1px solid #000;
            text-align: center;
            font-size: 12px;
        }
        .liste_articles tr.titres th {
            border-bottom: 1px solid #000;
            font-size: 13px;
        }

        .liste_articles td.total {
            text-align: right;
            font-size: 13px;
        }

        .total_tot {
            font-size: 15px;
            font-weight: bold;
            text-align: right;
        }

        .totaux {
            margin-top: 20px;
            width: 100%;
            float: right;
            text-align: right;
            font-size: 14px;
        }

        .totpay {
            margin-left: 50%;
            width: 100%;
            float: right;
            text-align: right;
            font-size: 14px;
        }

        .note{
            float: right;
            font-size: 12px;
            width: 100%;
            text-align: center;
        }

        .lien {
            position: absolute;
            top: 0;
            left: 0;
            display: none;
            font-size: 14px;
        }

        .dateh {
            display: block;
            width: 100%;
        }

        .date_heure {
            position: relative;
            right: 0;
            text-align: right;
            font-size: 12px;
            width: 100%;
            text-align: center;
        }

        .ticketbai_extrafields {
            display: block;
            width: 100%;
            position: relative;
            text-align: center;
        }

        @media print {
            .lien {
                display: none;
            }
            @page {
                margin: 0;
            }
        }
    </style>
</head>
<body onload="window.print()" onafterprint="<?php echo ($conf->global->POS_CLOSE_WIN?'window.close()':''); ?>">
<div class="entete">
    <?php
    if(!empty($conf->global->POS_TICKET_LOGO)) {
        $logoUrl = get_mycompanylogo();
        if (!empty($logoUrl)) {
            // Gorka 2025-01-29 - He creado la funcion resize_logo() en pos.lib.php para redimensionar el logo
            // Definimos el tama~o maximo que va a tener la imagen
            list($w,$h) = resize_logo('125');
        ?>
        <div class="logo">
            <?php
            print "<img src=\"".DOL_URL_ROOT.$logoUrl."\" width=\"".$w."\" height=\"".$h."\" />";
            ?>
        </div>
        <?php
        }
    }
    ?>
    <div class="infos">
        <p class="adresse">
            <?php
            echo $mysoc->name."<br />\n";
            echo $mysoc->idprof1."<br />\n";
            echo $mysoc->address."<br />\n";
            echo $mysoc->zip.' '.$mysoc->town."<br />\n";
            echo (!empty($mysoc->state_id)?getState($mysoc->state_id):'')."<br />\n";
            echo $mysoc->phone."<br />\n<br />\n";
            // Variables
            $object		= new Facture($db);
            $result		= $object->fetch($id,$ref);
            $userstatic	= new User($db);
            $userstatic->fetch($object->fk_user_valid);
            print $langs->trans('VendorPOS').": ".$userstatic->firstname." ".$userstatic->lastname."<br />\n<br />\n";
            $client		= new Societe($db);
            $client->fetch($object->socid);
            print $client->name."<br />\n";
            print $client->idprof1."<br />\n";
            print $client->address."<br />\n";
            print $client->zip." ".$client->town."<br />\n";
            print $client->state;

            $sql		= "SELECT fk_place,fk_cash FROM ".MAIN_DB_PREFIX."pos_facture WHERE fk_facture =".$object->id;
            $result		= $db->query($sql);
            if($result) {
                $objp = $db->fetch_object($result);
                if($objp->fk_place>0) {
                    $place = new Place($db);
                    $place->fetch($objp->fk_place);
                    print "<br />\n".$langs->trans('Place').": ".$place->name;
                }
            }
            ?>
        </p>
    </div>
</div>
<?php
if($result){
    if(!empty($object->lines)){
        $onediscount = false;
        foreach ($object->lines as $line){
            if($line->remise_percent) {
                $onediscount = true;
            }
        }
    }
}
if(!empty($object->note_private)) {
    ?>
    <div class="infos"><?php print $object->note_private; ?></div>
    <?php
}
?>
<div class="tables">
    <table class="liste_articles">
        <tr class="titres">
            <th><?php print $langs->trans('Label'); ?></th>
            <th><?php print $langs->trans('Qty')."/".$langs->trans('Price'); ?></th>
            <?php
            if($onediscount) {
                print "<th>".$langs->trans('DiscountLineal')."</th>\n";
            }
            ?>
            <th><?php print $langs->trans('Total'); ?></th>
        </tr>
        <?php
        if($result) {
            //$object->getLinesArray();
            if(!empty($object->lines)) {
                //$subtotal=0;
                $promos = 0;
                if(!empty($conf->global->MAIN_MULTILANGS)) {
                    $outputlangs = new Translate('',$conf);
                    $outputlangs->setDefaultLang($userstatic->lang);
                }
                foreach ($object->lines as $line) {
                    if($conf->discounts->enabled){
                        dol_include_once('/discounts/class/discount_doc.class.php');
                        $langs->load('discounts@discounts');
                        $dis_doc = new Discounts_doc($db);
                        $res	 = $dis_doc->fetch(3,$line->rowid);
                        if($res>0){
                            $are_promo = true;
                        }
                        else{
                            $are_promo = false;
                        }
                    }
                    if(empty($line->product_label)) {
                        $line->product_label = $line->desc;
                    }
                    $label = $line->product_label;
                    if(!empty($conf->global->MAIN_MULTILANGS)) {
                        $prodser = new Product($db);
                        if($line->fk_product) {
                            $prodser->fetch($line->fk_product);
                            if(!empty($conf->global->MAIN_MULTILANGS)) {
                                $label = $prodser->label;
                            }
                        }
                    }
                    $labeltxt = $label;
                    // Extraer el batch/lote de la descripción
                    $batch = '';
                    if (!empty($line->desc) && !empty($line->product_desc)) {
                        // Si la descripción completa contiene más que la descripción del producto, extraer la diferencia
                        if (strpos($line->desc, $line->product_desc) !== false) {
                            $batch = str_replace($line->product_desc, '', $line->desc);
                            $batch = trim($batch);
                        }
                    }
                    // Limpiar etiquetas HTML del batch
                    $batch = str_replace('<br />', '', $batch);
                    $batch = str_replace('<br>', '', $batch);
                    $batch = trim($batch);
                    
                    // Solo añadir el batch si no está vacío y no es igual al nombre del producto
                    if (!empty($batch) && $batch !== $label && $batch !== $line->product_desc) {
                        $label = $label . ' ' . $batch;
                    }
                    if($conf->global->POS_PRINT_MODE==1){
                        $label .= "&nbsp;&nbsp;&nbsp;<strong>Ref:</strong> ".$line->ref;
                    }
                    if(preg_match('/\(CREDIT_NOTE\)/',$line->product_label)) {
                        $line->product_label = preg_replace('/\(CREDIT_NOTE\)/',$langs->trans('CreditNote'),$line->product_label);
                    }
                    if(preg_match('/\(DEPOSIT\)/',$line->product_label)) {
                        $line->product_label = preg_replace('/\(DEPOSIT\)/', $langs->trans('Deposit'), $line->product_label);
                    }
                    // Gorka 2025-01-29 - Por algun motivo algunos importadores en la descripcion del articulo sustituyen los espacios por guiones bajos
                    // Esto crea lineas largisimas que "empujan" la celda de la tabla apareciendo el precio en otra linea
                    // Por si acaso quitamos los guiones bajos
                    //$label = str_replace('_',' ',$label);
                    if($are_promo) {
                        echo "<tr>\n";
                        echo "<td style=\"text-align:left;\">".$label."</td>\n";
                        $price = price(price2num($dis_doc->ori_subprice*(1+$line->tva_tx/100)),0,'',1,-1,$conf->global->MAIN_MAX_DECIMALS_TOT);
                        print "<td style=\"text-align:left;\">".$line->qty." * ".$price."</td>\n";
                        if($onediscount) {
                            print "<td style=\"text-align:right;\">".$line->remise_percent."%</td>\n";
                        }
                        print "<td class=\"total\">".$price."</td>\n";
                        print "</tr>\n";
                        print "<tr>\n";
                        print "<td style=\"text-align:left;\">".$dis_doc->descr."</td>\n";
                        print "<td style=\"text-align:left;\"></td>\n";
                        if($onediscount) {
                            "<td style=\"text-align:right;\"></td>\n";
                        }
                        $price = price(price2num($dis_doc->ori_totalht*(1+$line->tva_tx/100)-$line->total_ttc),0,'',1,-1,$conf->global->MAIN_MAX_DECIMALS_TOT);
                        print "<td class=\"total\">-".$price."</td>\n";
                        print "</tr>\n";
                        $linepromo = $dis_doc->ori_totalht*(1+$line->tva_tx/100)-$line->total_ttc;
                        $promos	  += $linepromo;
                    }
                    else{
                        print "<tr>\n";
                        print "<td style=\"text-align:left;\">".$label."</td>\n";
                        $price = price(price2num($line->subprice*(1+$line->tva_tx/100)),0,'',1,-1,$conf->global->MAIN_MAX_DECIMALS_TOT);
                        print "<td style=\"text-align:left;\">".$line->qty." * ".$price."</td>\n";
                        if($onediscount) {
                            print "<td style=\"text-align:right;\">".$line->remise_percent."%</td>\n";
                        }
                        $price = price(price2num($line->total_ttc),0,'',1,-1,$conf->global->MAIN_MAX_DECIMALS_TOT);
                        print "<td class=\"total\">".$price."</td>\n";
                        print "</tr>\n";
                    }
                    $subtotal[$line->tva_tx]	+= $line->total_ht;
                    $subtotaltva[$line->tva_tx]	+= $line->total_tva;
                    if(!empty($line->total_localtax1)){
                        $localtax1 = $line->localtax1_tx;
                    }
                    if(!empty($line->total_localtax2)){
                        $localtax2 = $line->localtax2_tx;
                    }
                }
            }
            else {
                echo "<p>". $langs->trans('ErrNoArticles')."</p>\n";
            }
        }
        ?>
    </table>
    <?php
    if($promos>0) {
        ?>
        <div class="total_tot">
            <?php
            echo $langs->trans('InPromo')."   -".price(price2num($promos, 4))." ".$langs->trans(currency_name($conf->currency));
            ?>
        </div>
        <?php
    }
    ?>
    <div class="total_tot">
        <?php
        echo $langs->trans('TotalTTC')."   ".price(price2num($object->total_ttc))." ".$langs->trans(currency_name($conf->currency));
        ?>
    </div>
    <table class="totaux">
        <?php
        print "<tr>\n";
        print "<th style=\"width:50%;white-space:nowrap;\">".$langs->trans('TotalHT')."</th>\n";
        print "<th style=\"width:25%;white-space:nowrap;\">".$langs->trans('VAT')."</th>\n";
        print "<th style=\"width:25%;white-space:nowrap;\">".$langs->trans('TotalVAT')."</th>\n";
        print "</tr>\n";
        if(!empty($subtotal)) {
            foreach($subtotal as $totkey => $totval){
                print "<tr>\n";
                print "<td style=\"text-align:left;white-space:nowrap;\">".price(price2num($subtotal[$totkey]))."</td>\n";
                print "<td style=\"white-space:nowrap;\">".price(price2num($totkey))."%</td>\n";
                print "<td style=\"white-space:nowrap;\">".price(price2num($subtotaltva[$totkey]))."</td>\n";
                print "</tr>\n";
            }
        }
        print "<tr>\n";
        print "<td style=\"border-top: 1px dashed #000000;text-align:left;white-space:nowrap;\">".price(price2num($object->total_ht))."</td>\n";
        print "<td style=\"border-top: 1px dashed #000000;\">--</td>\n";
        print "<td style=\"border-top: 1px dashed #000000;white-space:nowrap;\">".price(price2num($object->total_tva))."</td>\n";
        print "</tr>\n";
        if($object->total_localtax1!=0) {
            print "<tr>\n";
            print "<td></td>\n";
            print "<td style=\"white-space:nowrap;\">".$langs->transcountrynoentities('TotalLT1',$mysoc->country_code)." ".price(price2num($localtax1))."%</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($object->total_localtax1))."</td>\n";
            print "</tr>\n";
        }
        if($object->total_localtax2!=0){
            print "<tr>\n";
            print "<td></td>\n";
            print "<td style=\"white-space:nowrap;\">".$langs->transcountrynoentities('TotalLT2',$mysoc->country_code)." ".price(price2num($localtax2))."%</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($object->total_localtax2))."</td>\n";
            print "</tr>\n";
        }
        ?>
    </table>
    <table class="totpay">
        <?php
        print "<tr>\n";
        print "<td></td>\n";
        print "</tr>\n";
        print "<tr>\n";
        print "<td></td>\n";
        print "</tr>\n";
        $terminal	  = new Cash($db);
        $sql		  = "SELECT fk_cash, customer_pay FROM ".MAIN_DB_PREFIX."pos_facture WHERE fk_facture = ".$object->id;
        $resql		  = $db->query($sql);
        $obj		  = $db->fetch_object($resql);
        $customer_pay = $obj->customer_pay;
        $terminal->fetch($obj->fk_cash);
        if(!empty($conf->rewards->enabled)){
            dol_include_once('/rewards/class/rewards.class.php');
            $rewards = new Rewards($db);
            $points	 = $rewards->getInvoicePoints($object->id);
        }
        if($object->type==0) {
            $pay	 = $object->getSommePaiement(1);
            $coupon	 = $object->getSumCreditNotesUsed();
            $coupon += $object->getSumDepositsUsed();
            $pay	+= $coupon;
            if(!empty($conf->rewards->enabled)){
                $usepoints	 = abs($rewards->getInvoicePoints($object->id,1));
                //falta fer algo per aci
                $moneypoints = abs($usepoints*$conf->global->REWARDS_DISCOUNT);
                if($customer_pay>$pay-$moneypoints) {
                    $pay = $customer_pay;
                }
                else
                    $pay = $pay-$moneypoints;
            }
            else {
                if($customer_pay>$pay) {
                    $pay = $customer_pay;
                }
            }
        }
        if($object->type==2) {
            $customer_pay = $customer_pay*-1;
            $pay = $object->getSommePaiement(1);
            if(!empty($conf->rewards->enabled)){
                $usepoints	 = abs($rewards->getInvoicePoints($object->id,0));
                //falta fer algo per aci
                $moneypoints = -1*($usepoints*$conf->global->REWARDS_DISCOUNT);
                if($customer_pay>$pay-$moneypoints) {
                    $pay = $customer_pay;
                }
                else {
                    $pay = $pay-$moneypoints;
                }
            }
            else{
                if($customer_pay>$pay) {
                    $pay = $customer_pay;
                }
            }
        }
        $diff_payment	= $object->total_ttc-$moneypoints-$pay;
        $listofpayments	= $object->getListOfPayments();
        foreach($listofpayments as $paym) {
            if($paym['type']!='PNT'){
                if($paym['type']!='(CREDIT_NOTE)' && $paym['type']!='(EXCESS RECEIVED)') {
                    if($paym['type']!='LIQ') {
                        print "<tr>\n";
                        print "<td style=\"white-space:nowrap;\">".$terminal->select_Paymentname(dol_getIdFromCode($db,$paym['type'],'c_paiement'))."</td>\n";
                        print "<td style=\"white-space:nowrap;\">".price(price2num($paym['amount']))." ".$langs->trans(currency_name($conf->currency))."</td>\n";
                        print "</tr>\n";
                    }
                    else {
                        print "<tr>\n";
                        print "<td style=\"white-space:nowrap;\">".$terminal->select_Paymentname(dol_getIdFromCode($db,$paym['type'],'c_paiement'))."</td>\n";
                        $price = price(price2num($paym['amount']-(($object->type>1?$diff_payment*-1:$diff_payment)<0?$diff_payment:0)));
                        print "<td style=\"white-space:nowrap;\">".$price." ".$langs->trans(currency_name($conf->currency))."</td>\n";
                        print "</tr>\n";
                    }
                }
            }
        }
        if($coupon > 0){
            print "<tr>\n";
            print "<dh style=\"white-space:nowrap;\">".$langs->trans('Discount')."</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($coupon))." ".$langs->trans(currency_name($conf->currency))."</td>\n";
            print "</tr>\n";
        }
        if(! empty($conf->rewards->enabled)){
            if($moneypoints!=0){
                print "<tr>\n";
                print "<td style=\"white-space:nowrap;\">".$usepoints." ".$langs->trans('Points')."</td>\n";
                print "<td style=\"white-space:nowrap;\">".price(price2num($moneypoints))." ".$langs->trans(currency_name($conf->currency))."</td>\n";
                print "</tr>\n";
            }
        }
        $discount = new DiscountAbsolute($db);
        $result	  = $discount->getAvailableDiscounts('','','fk_facture_source = '. $object->id);
        if($result > 0) {
            print "<tr>\n";
            print "<td style=\"white-space:nowrap;\">".$langs->trans('ReductionConvert')."</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($result))."</td>\n";
            print "</tr>\n";
        }
        else{
            print "<tr>\n";
            $difpay = (($object->type>1?$diff_payment*-1:$diff_payment)<0?$langs->trans('CustomerRet'):$langs->trans('CustomerDeb'));
            print "<th style=\"white-space:nowrap;\">".$difpay."</th>\n";
            print "<td style=\"white-space:nowrap;\">".price(abs(price2num($diff_payment)))." ".$langs->trans(currency_name($conf->currency))."</td>\n";
            print "</tr>\n";
        }
        if($points!=0 && !empty($conf->rewards->enabled)) {
            print "<tr>\n";
            print "<td style=\"white-space:nowrap;\">".$langs->trans('TotalPointsInvoice')."</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($points))." ".$langs->trans('Points')."</td>\n";
            print "</tr>\n";
            $total_points = $rewards->getCustomerPoints($object->socid);
            print "<tr>\n";
            print "<td style=\"white-space:nowrap;\">".$langs->trans('DispoPoints')."</td>\n";
            print "<td style=\"white-space:nowrap;\">".price(price2num($total_points))." ".$langs->trans('Points')."</td>\n";
            print "</tr>\n";
        }
        ?>
    </table>
</div><!-- end tables -->
<div class="note"><p><?php print $conf->global->POS_PREDEF_MSG; ?></p></div>
<div class="dateh">
    <?php
    $now = dol_now();
    print "<p class=\"date_heure\" align=\"right\">".$object->ref." ".dol_print_date($object->date_creation,'dayhour')."</p>\n";
    ?>
</div>
<!-- Gorka 2025-01-27 - Mostrar el codigo qr e id tbai al pie del ticket -->
<?php
// Comprobamos si hay una instancia de DolTicketBAi instalada
if(!empty($conf->global->ID_TICKETBAI)) {
    // Si esta instalado el modulo incluimos el QR y el codigo TicketBAI
    ?>
    <div class="ticketbai_extrafields">
        <?php
        $id_tbai = $object->array_options['options_id_tbai'];
        $qrcode	 = $object->array_options['options_qrcode'];
        $img	 = "<img src=\"data:image/png;base64,".$qrcode."\" width=\"150\" height=\"150\" />";

        if(!empty($id_tbai) && !empty($img)){
            print $id_tbai."<br />\n";
            print $img;
        }

        ?>
    </div>
    <?php
}
?>
</body>
</html>