<?php
/* Copyright (C) 2012      Juanjo Menent        <jmenent@2byte.es>
 * Copyright (C) 2014-2017 Ferran Marcet        <fmarcet@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

function posadmin_prepare_head()
{
    global $langs;

	$langs->load('pos@pos');
    $h = 0;
    $head = array();
    $head[$h][0] = dol_buildpath('/pos/admin/pos.php', 1);
    $head[$h][1] = $langs->trans("POSSetup");
    $head[$h][2] = 'configuration';
    $h++;
    return $head;
}

/**
 * Get company logo URL for POS tickets
 * @return string URL to the company logo
 */
function get_mycompanylogo(){
	global $conf;

	// Obtener el logo de la empresa principal desde las constantes
	$logo = $conf->global->MAIN_INFO_SOCIETE_LOGO;
	
	if (!empty($logo)) {
		$logoPath = DOL_DATA_ROOT . '/mycompany/logos/' . $logo;
		if (is_file($logoPath)) {
			return '/viewimage.php?modulepart=mycompany&amp;file=' . urlencode('logos/' . $logo);
		}
	}

	// Si no existe el logo principal, intentamos con el logo cuadrado
	$logo_squarred = $conf->global->MAIN_INFO_SOCIETE_LOGO_SQUARRED;
	if (!empty($logo_squarred)) {
		$logoPath = DOL_DATA_ROOT . '/mycompany/logos/' . $logo_squarred;
		if (is_file($logoPath)) {
			return '/viewimage.php?modulepart=mycompany&amp;file=' . urlencode('logos/' . $logo_squarred);
		}
	}

	// Si no hay logo configurado, buscamos cualquier archivo .png en el directorio de logos
	$logosDir = DOL_DATA_ROOT . '/mycompany/logos/';
	if (is_dir($logosDir)) {
		$files = glob($logosDir . '*.png');
		if (!empty($files)) {
			$logoFile = basename($files[0]);
			return '/viewimage.php?modulepart=mycompany&amp;file=' . urlencode('logos/' . $logoFile);
		}
	}

	// Si no encontramos nada, devolvemos una URL vacía
	return '';
}

/**
 * Resize logo for POS tickets
 * @param int|null $mxw Maximum width
 * @param int|null $mxh Maximum height
 * @return array [width, height] of the resized logo
 */
function resize_logo($mxw = null, $mxh = null)
{
	global $conf;

	// 1) Construimos un array de rutas candidatas al fichero físico
	$candidates = [];

	// A) Logo principal de la empresa desde constantes
	$logo = $conf->global->MAIN_INFO_SOCIETE_LOGO;
	if (!empty($logo)) {
		$candidates[] = DOL_DATA_ROOT . '/mycompany/logos/' . $logo;
	}

	// B) Logo cuadrado de la empresa desde constantes
	$logo_squarred = $conf->global->MAIN_INFO_SOCIETE_LOGO_SQUARRED;
	if (!empty($logo_squarred)) {
		$candidates[] = DOL_DATA_ROOT . '/mycompany/logos/' . $logo_squarred;
	}

	// C) Buscar cualquier archivo .png en el directorio de logos principal
	$logosDir = DOL_DATA_ROOT . '/mycompany/logos/';
	if (is_dir($logosDir)) {
		$files = glob($logosDir . '*.png');
		if (!empty($files)) {
			$candidates[] = $files[0];
		}
	}

	// 2) Escogemos la primera ruta válida
	$logoPath = '';
	foreach ($candidates as $path) {
		if (is_file($path)) {
			$logoPath = $path;
			break;
		}
	}
	
	if (!$logoPath) {
		// No hay logo disponible
		return [0, 0];
	}

	// 3) Obtenemos dimensiones originales
	$info = @getimagesize($logoPath);
	if (!$info || $info[0] <= 0 || $info[1] <= 0) {
		return [0, 0];
	}
	list($width, $height) = $info;

	// 4) Calculamos proporción
	$ratio = $width / $height;

	// 5) Redimensionamiento según restricciones
	if (!empty($mxw) && !empty($mxh)) {
		// Ambos límites: elegimos el más restrictivo
		$scale = min($mxw / $width, $mxh / $height);
		$newW  = (int) round($width * $scale);
		$newH  = (int) round($height * $scale);
	} elseif (!empty($mxw)) {
		// Solo ancho
		$newW = (int) $mxw;
		$newH = (int) round($mxw / $ratio);
	} elseif (!empty($mxh)) {
		// Solo alto
		$newH = (int) $mxh;
		$newW = (int) round($mxh * $ratio);
	} else {
		// Sin límites: original
		$newW = $width;
		$newH = $height;
	}

	return [$newW, $newH];
}
?>
