<?php
// For root directory
$res = @include('../../../main.inc.php');
// For "custom" directory
if(!$res) {
	$res = @include('../../../../main.inc.php');
}
require_once DOL_DOCUMENT_ROOT."/compta/facture/class/facture.class.php";
require_once DOL_DOCUMENT_ROOT."/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT."/core/class/discount.class.php";
dol_include_once('/pos/class/cash.class.php');
dol_include_once('/pos/backend/lib/pos.lib.php');

global $langs,$db,$mysoc,$conf;

$langs->load('main');
$langs->load('pos@pos');
$langs->load('rewards@rewards');
$langs->load('bills');
$id = GETPOST('id');
?>
<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="UTF-8">
	<title>Print facture</title>
	<style type="text/css">
		body {
			font-size: 14px;
			position: relative;
			font-family: monospace,courier,arial,helvetica,system;
	        margin: 35px;
		}

		.entete {
			width: 100%;
			/*position: relative;*/
		}

		.infos {
			position: relative;
			font-size: 14px;
			width: 100%;
			text-align: center;
		}

		.logo {
			width: 100%;
			text-align: center;
		}

		.adresse {
			/*float: left;*/
			font-size: 12px;
		}

		.tables {
			display: block;
			width: 100%;
		}

		.liste_articles {
			width: 100%;
			border-bottom: 1px solid #000;
			text-align: center;
			font-size: 12px;
		}
		.liste_articles tr.titres th {
			border-bottom: 1px solid #000;
			font-size: 13px;
		}

		.liste_articles td.total {
			text-align: right;
			font-size: 13px;
		}

		.total_tot {
		    font-size: 15px;
		    font-weight: bold;
		    text-align: right;
		}

		.totaux {
			margin-top: 20px;
			width: 100%;
			float: right;
			text-align: right;
			font-size: 14px;
		}

		.totpay {
			margin-left: 50%;
			width: 100%;
			float: right;
			text-align: right;
			font-size: 14px;
		}

		.note{
			float: right;
			font-size: 12px;
			width: 100%;
			text-align: center;
		}

		.lien {
			position: absolute;
			top: 0;
			left: 0;
			display: none;
			font-size: 14px;
		}

		.dateh {
			display: block;
			width: 100%;
		}

		.date_heure {
			position: relative;
			right: 0;
			text-align: right;
			font-size: 12px;
			width: 100%;
			text-align: center;
		}

		.ticketbai_extrafields {
			display: block;
			width: 100%;
			position: relative;
			text-align: center;
		}

		@media print {
			.lien {
				display: none;
			}
			@page {
				margin: 0;
			}
		}
	</style>
</head>
<body onload="window.print()" onafterprint="<?php echo ($conf->global->POS_CLOSE_WIN?'window.close()':''); ?>">
	<div class="entete">
		<?php
		if(!empty($conf->global->POS_TICKET_LOGO)) {
			$logoUrl = get_mycompanylogo();
			if (!empty($logoUrl)) {
				// Gorka 2025-01-29 - He creado la funcion resize_logo() en pos.lib.php para redimensionar el logo
				// Definimos el tama~o maximo que va a tener la imagen
				list($w,$h) = resize_logo('125');
			?>
			<div class="logo">
				<?php
				print "<img src=\"".DOL_URL_ROOT.$logoUrl."\" width=\"".$w."\" height=\"".$h."\" />";
				?>
			</div>
			<?php
			}
		}
		?>
		<div class="infos">
			<p class="adresse">
				<?php
				echo $mysoc->name."<br />\n";
				echo $mysoc->idprof1."<br />\n";
				echo $mysoc->address."<br />\n";
				echo $mysoc->zip.' '.$mysoc->town."<br />\n";
				echo (!empty($mysoc->state_id)?getState($mysoc->state_id):'')."<br />\n";
				echo $mysoc->phone."<br />\n<br />\n";
				// Variables
				$object		= new Facture($db);
				$result		= $object->fetch($id,$ref);
				$userstatic	= new User($db);
				$userstatic->fetch($object->fk_user_valid);
				print $langs->trans('VendorPOS').": ".$userstatic->firstname." ".$userstatic->lastname."<br />\n<br />\n";
				$client		= new Societe($db);
				$client->fetch($object->socid);
				print $client->name."<br />\n";
				print $client->idprof1."<br />\n";
				print $client->address."<br />\n";
				print $client->zip." ".$client->town."<br />\n";
				print $client->state;

				$sql		= "SELECT fk_place,fk_cash FROM ".MAIN_DB_PREFIX."pos_facture WHERE fk_facture =".$object->id;
				$result		= $db->query($sql);
				if($result) {
					$objp = $db->fetch_object($result);
					if($objp->fk_place>0) {
						$place = new Place($db);
						$place->fetch($objp->fk_place);
						print "<br />\n".$langs->trans('Place').": ".$place->name;
					}
				}
				?>
			</p>
		</div>
	</div>
	<?php
	if($result){
		if(!empty($object->lines)){
			$onediscount = false;
			foreach ($object->lines as $line){
				if($line->remise_percent) {
					$onediscount = true;
				}
			}
		}
	}
	if(!empty($object->note_private)) {
		?>
	<div class="infos"><?php print $object->note_private; ?></div>
		<?php
	}
	?>
	<div class="tables">
		<table class="liste_articles">
			<tr class="titres">
				<th><?php print $langs->trans('Label'); ?></th>
				<th><?php print $langs->trans('Qty'); ?></th>
			</tr>
			<?php
			if($result) {
				//$object->getLinesArray();
				if(!empty($object->lines)) {
					//$subtotal=0;
					$promos = 0;
					if(!empty($conf->global->MAIN_MULTILANGS)) {
						$outputlangs = new Translate('',$conf);
						$outputlangs->setDefaultLang($userstatic->lang);
					}
					foreach ($object->lines as $line) {
						if(empty($line->product_label)) {
							$line->product_label = $line->desc;
						}
						$label = $line->product_label;
						if(!empty($conf->global->MAIN_MULTILANGS)) {
							$prodser = new Product($db);
							if($line->fk_product) {
								$prodser->fetch($line->fk_product);
								if(!empty($conf->global->MAIN_MULTILANGS)) {
									$label = $prodser->label;
								}
							}
						}
						$labeltxt = $label;
						$batch	  = str_replace($line->product_desc,'',$line->desc);
						$label	  = $label.$batch;
						$batch	  = str_replace('<br />','',$batch);
						if($conf->global->POS_PRINT_MODE==1){
							$label .= "&nbsp;&nbsp;&nbsp;<strong>Ref:</strong> ".$line->ref;
						}
						if(preg_match('/\(CREDIT_NOTE\)/',$line->product_label)) {
							$line->product_label = preg_replace('/\(CREDIT_NOTE\)/',$langs->trans('CreditNote'),$line->product_label);
						}
						if(preg_match('/\(DEPOSIT\)/',$line->product_label)) {
							$line->product_label = preg_replace('/\(DEPOSIT\)/', $langs->trans('Deposit'), $line->product_label);
						}
						// Gorka 2025-01-29 - Por algun motivo algunos importadores en la descripcion del articulo sustituyen los espacios por guiones bajos
						// Esto crea lineas largisimas que "empujan" la celda de la tabla apareciendo el precio en otra linea
						// Por si acaso quitamos los guiones bajos
						//$label = str_replace('_',' ',$label);

						print "<tr>\n";
						print "<td style=\"text-align:left;\">".$label."</td>\n";
						print "<td style=\"text-align:left;\">".$line->qty."</td>\n";
						print "</tr>\n";
					}
				}
				else {
					echo "<p>". $langs->trans('ErrNoArticles')."</p>\n";
				}
			}
			?>
		</table>
	</div><!-- end tables -->
	<div class="note"><p><?php print $conf->global->POS_PREDEF_MSG; ?></p></div>
	<div class="dateh">
		<?php
		$now = dol_now();
		print "<p class=\"date_heure\" align=\"right\">".$object->ref." ".dol_print_date($object->date_creation,'dayhour')."</p>\n";
		?>
	</div>
	<!-- Gorka 2025-01-27 - Mostrar el codigo qr e id tbai al pie del ticket -->
	<?php
	// Comprobamos si hay una instancia de DolTicketBAi instalada
	if(!empty($conf->global->ID_TICKETBAI)) {
		// Si esta instalado el modulo incluimos el QR y el codigo TicketBAI
		?>
	<div class="ticketbai_extrafields">
		<?php
			$id_tbai = $object->array_options['options_id_tbai'];
			$qrcode	 = $object->array_options['options_qrcode'];
			$img	 = "<img src=\"data:image/png;base64,".$qrcode."\" width=\"150\" height=\"150\" />";

			if(!empty($id_tbai) && !empty($img)){
				print $id_tbai."<br />\n";
				print $img;
			}

		?>
	</div>
		<?php
	}
	?>
</body>
</html>
